/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.v4;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.tsfile.annotations.TsFileApi;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.read.ReadProcessException;
import org.apache.tsfile.exception.write.NoMeasurementException;
import org.apache.tsfile.exception.write.NoTableException;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.controller.CachedChunkLoaderImpl;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.controller.IMetadataQuerier;
import org.apache.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.tsfile.read.expression.ExpressionTree;
import org.apache.tsfile.read.query.dataset.ResultSet;
import org.apache.tsfile.read.query.dataset.TableResultSet;
import org.apache.tsfile.read.query.executor.TableQueryExecutor;
import org.apache.tsfile.read.reader.block.TsBlockReader;
import org.apache.tsfile.read.v4.ITsFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceTableModelReader
implements ITsFileReader {
    protected TsFileSequenceReader fileReader;
    protected IMetadataQuerier metadataQuerier;
    protected IChunkLoader chunkLoader;
    protected TableQueryExecutor queryExecutor;
    private static final Logger LOG = LoggerFactory.getLogger(DeviceTableModelReader.class);

    public DeviceTableModelReader(File file) throws IOException {
        this.fileReader = new TsFileSequenceReader(file.getPath());
        this.fileReader.setEnableCacheTableSchemaMap();
        this.metadataQuerier = new MetadataQuerierByFileImpl(this.fileReader);
        this.chunkLoader = new CachedChunkLoaderImpl(this.fileReader);
        this.queryExecutor = new TableQueryExecutor(this.metadataQuerier, this.chunkLoader, TableQueryExecutor.TableQueryOrdering.DEVICE);
    }

    @Override
    @TsFileApi
    public List<TableSchema> getAllTableSchema() throws IOException {
        Map<String, TableSchema> tableSchemaMap = this.fileReader.getTableSchemaMap();
        return new ArrayList<TableSchema>(tableSchemaMap.values());
    }

    @Override
    @TsFileApi
    public Optional<TableSchema> getTableSchemas(String tableName) throws IOException {
        Map<String, TableSchema> tableSchemaMap = this.fileReader.getTableSchemaMap();
        return Optional.ofNullable(tableSchemaMap.get(tableName.toLowerCase()));
    }

    @Override
    @TsFileApi
    public ResultSet query(String tableName, List<String> columnNames, long startTime, long endTime) throws IOException, NoTableException, NoMeasurementException, ReadProcessException {
        String lowerCaseTableName = tableName.toLowerCase();
        TableSchema tableSchema = this.fileReader.getTableSchemaMap().get(lowerCaseTableName);
        if (tableSchema == null) {
            throw new NoTableException(tableName);
        }
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>(columnNames.size());
        ArrayList<String> lowerCaseColumnNames = new ArrayList<String>(columnNames.size());
        for (String columnName : columnNames) {
            Map<String, Integer> column2IndexMap = tableSchema.buildColumnPosIndex();
            Integer columnIndex = column2IndexMap.get(columnName.toLowerCase());
            if (columnIndex == null) {
                throw new NoMeasurementException(columnName);
            }
            lowerCaseColumnNames.add(columnName.toLowerCase());
            dataTypeList.add(tableSchema.getColumnSchemas().get(columnIndex).getType());
        }
        TsBlockReader tsBlockReader = this.queryExecutor.query(lowerCaseTableName, lowerCaseColumnNames, new ExpressionTree.TimeBetweenAnd(startTime, endTime), null, null);
        return new TableResultSet(tsBlockReader, columnNames, dataTypeList);
    }

    @Override
    public void close() {
        try {
            this.fileReader.close();
        }
        catch (IOException e) {
            LOG.warn("Meet exception when close file reader: ", (Throwable)e);
        }
    }
}

