/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.schemaregion;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.datastructure.queue.listening.AbstractPipeListeningQueue;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.SerializableEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionSnapshotEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaSerializableEventType;
import org.apache.iotdb.db.pipe.source.schemaregion.SchemaRegionListeningFilter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedNonWritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedWritePlanNode;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegionListeningQueue
extends AbstractPipeListeningQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaRegionListeningQueue.class);
    private static final String SNAPSHOT_FILE_NAME = "pipe_schema_region_listening_queue.bin";

    public synchronized void tryListenToNode(PlanNode node) {
        if (SchemaRegionListeningFilter.shouldPlanBeListened(node)) {
            PipeSchemaRegionWritePlanEvent event;
            switch (node.getType()) {
                case PIPE_ENRICHED_WRITE: {
                    event = new PipeSchemaRegionWritePlanEvent(((PipeEnrichedWritePlanNode)node).getWritePlanNode(), true);
                    break;
                }
                case PIPE_ENRICHED_NON_WRITE: {
                    event = new PipeSchemaRegionWritePlanEvent(((PipeEnrichedNonWritePlanNode)node).getNonWritePlanNode(), true);
                    break;
                }
                default: {
                    event = new PipeSchemaRegionWritePlanEvent(node, false);
                }
            }
            this.tryListen((EnrichedEvent)event);
        }
    }

    public synchronized void tryListenToSnapshot(String mTreeSnapshotPath, String tLogPath, String databaseName) {
        this.tryListen(Objects.nonNull(mTreeSnapshotPath) ? Collections.singletonList(new PipeSchemaRegionSnapshotEvent(mTreeSnapshotPath, tLogPath, databaseName)) : Collections.emptyList());
    }

    protected ByteBuffer serializeToByteBuffer(Event event) {
        return ((SerializableEvent)event).serializeToByteBuffer();
    }

    protected Event deserializeFromByteBuffer(ByteBuffer byteBuffer) {
        try {
            SerializableEvent result = PipeSchemaSerializableEventType.deserialize(byteBuffer);
            ((EnrichedEvent)result).increaseReferenceCount(SchemaRegionListeningQueue.class.getName());
            return result;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load snapshot from byteBuffer {}.", (Object)byteBuffer);
            return null;
        }
    }

    public synchronized boolean createSnapshot(File snapshotDir) {
        try {
            return super.serializeToFile(new File(snapshotDir, SNAPSHOT_FILE_NAME));
        }
        catch (Exception e) {
            LOGGER.warn("Take snapshot error: {}", (Object)e.getMessage());
            return false;
        }
    }

    public synchronized void loadSnapshot(File snapshotDir) {
        try {
            super.deserializeFromFile(new File(snapshotDir, SNAPSHOT_FILE_NAME));
        }
        catch (Exception e) {
            LOGGER.error("Failed to load snapshot {}", (Object)e.getMessage());
        }
    }
}

