/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi;

import java.io.IOException;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi.UDFQueryTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.db.queryengine.transformation.datastructure.iterator.TVListForwardIterator;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.TimeColumn;

public abstract class UniversalUDFQueryTransformer
extends UDFQueryTransformer {
    protected final ElasticSerializableTVList outputStorage;
    protected final TVListForwardIterator outputLayerIterator;

    protected UniversalUDFQueryTransformer(UDTFExecutor executor) {
        super(executor);
        this.outputStorage = executor.getOutputStorage();
        this.outputLayerIterator = this.outputStorage.constructIterator();
    }

    @Override
    protected final YieldableState yieldValue() throws Exception {
        while (!this.cacheValueFromUDFOutput()) {
            YieldableState udfYieldableState = this.tryExecuteUDFOnce();
            if (udfYieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
            }
            if (udfYieldableState != YieldableState.NOT_YIELDABLE_NO_MORE_DATA || this.terminate()) continue;
            return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
        }
        return YieldableState.YIELDABLE;
    }

    protected abstract YieldableState tryExecuteUDFOnce() throws Exception;

    protected final boolean cacheValueFromUDFOutput() throws IOException {
        if (!this.outputLayerIterator.hasNext()) {
            return false;
        }
        this.outputLayerIterator.next();
        Column values = this.outputLayerIterator.currentValues();
        TimeColumn times = this.outputLayerIterator.currentTimes();
        this.cachedColumns = new Column[]{values, times};
        this.outputStorage.setEvictionUpperBound(this.outputLayerIterator.getEndPointIndex());
        return true;
    }

    @Override
    public final boolean isConstantPointReader() {
        return false;
    }
}

