/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CallMethodResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=707");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=709");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=708");
    private final StatusCode statusCode;
    private final StatusCode[] inputArgumentResults;
    private final DiagnosticInfo[] inputArgumentDiagnosticInfos;
    private final Variant[] outputArguments;

    public CallMethodResult(StatusCode statusCode, StatusCode[] inputArgumentResults, DiagnosticInfo[] inputArgumentDiagnosticInfos, Variant[] outputArguments) {
        this.statusCode = statusCode;
        this.inputArgumentResults = inputArgumentResults;
        this.inputArgumentDiagnosticInfos = inputArgumentDiagnosticInfos;
        this.outputArguments = outputArguments;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public StatusCode[] getInputArgumentResults() {
        return this.inputArgumentResults;
    }

    public DiagnosticInfo[] getInputArgumentDiagnosticInfos() {
        return this.inputArgumentDiagnosticInfos;
    }

    public Variant[] getOutputArguments() {
        return this.outputArguments;
    }

    protected CallMethodResult(CallMethodResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((CallMethodResultBuilder)b).statusCode;
        this.inputArgumentResults = ((CallMethodResultBuilder)b).inputArgumentResults;
        this.inputArgumentDiagnosticInfos = ((CallMethodResultBuilder)b).inputArgumentDiagnosticInfos;
        this.outputArguments = ((CallMethodResultBuilder)b).outputArguments;
    }

    public static CallMethodResultBuilder<?, ?> builder() {
        return new CallMethodResultBuilderImpl();
    }

    public CallMethodResultBuilder<?, ?> toBuilder() {
        return new CallMethodResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallMethodResult)) {
            return false;
        }
        CallMethodResult other = (CallMethodResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInputArgumentResults(), other.getInputArgumentResults())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInputArgumentDiagnosticInfos(), other.getInputArgumentDiagnosticInfos())) {
            return false;
        }
        return Arrays.deepEquals(this.getOutputArguments(), other.getOutputArguments());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallMethodResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInputArgumentResults());
        result = result * 59 + Arrays.deepHashCode(this.getInputArgumentDiagnosticInfos());
        result = result * 59 + Arrays.deepHashCode(this.getOutputArguments());
        return result;
    }

    @Override
    public String toString() {
        return "CallMethodResult(statusCode=" + this.getStatusCode() + ", inputArgumentResults=" + Arrays.deepToString(this.getInputArgumentResults()) + ", inputArgumentDiagnosticInfos=" + Arrays.deepToString(this.getInputArgumentDiagnosticInfos()) + ", outputArguments=" + Arrays.deepToString(this.getOutputArguments()) + ")";
    }

    private static final class CallMethodResultBuilderImpl
    extends CallMethodResultBuilder<CallMethodResult, CallMethodResultBuilderImpl> {
        private CallMethodResultBuilderImpl() {
        }

        @Override
        protected CallMethodResultBuilderImpl self() {
            return this;
        }

        @Override
        public CallMethodResult build() {
            return new CallMethodResult(this);
        }
    }

    public static abstract class CallMethodResultBuilder<C extends CallMethodResult, B extends CallMethodResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private StatusCode[] inputArgumentResults;
        private DiagnosticInfo[] inputArgumentDiagnosticInfos;
        private Variant[] outputArguments;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CallMethodResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CallMethodResult instance, CallMethodResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.inputArgumentResults(instance.inputArgumentResults);
            b.inputArgumentDiagnosticInfos(instance.inputArgumentDiagnosticInfos);
            b.outputArguments(instance.outputArguments);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B inputArgumentResults(StatusCode[] inputArgumentResults) {
            this.inputArgumentResults = inputArgumentResults;
            return (B)this.self();
        }

        public B inputArgumentDiagnosticInfos(DiagnosticInfo[] inputArgumentDiagnosticInfos) {
            this.inputArgumentDiagnosticInfos = inputArgumentDiagnosticInfos;
            return (B)this.self();
        }

        public B outputArguments(Variant[] outputArguments) {
            this.outputArguments = outputArguments;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CallMethodResult.CallMethodResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", inputArgumentResults=" + Arrays.deepToString(this.inputArgumentResults) + ", inputArgumentDiagnosticInfos=" + Arrays.deepToString(this.inputArgumentDiagnosticInfos) + ", outputArguments=" + Arrays.deepToString(this.outputArguments) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CallMethodResult> {
        @Override
        public Class<CallMethodResult> getType() {
            return CallMethodResult.class;
        }

        @Override
        public CallMethodResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            StatusCode[] inputArgumentResults = decoder.readStatusCodeArray("InputArgumentResults");
            DiagnosticInfo[] inputArgumentDiagnosticInfos = decoder.readDiagnosticInfoArray("InputArgumentDiagnosticInfos");
            Variant[] outputArguments = decoder.readVariantArray("OutputArguments");
            return new CallMethodResult(statusCode, inputArgumentResults, inputArgumentDiagnosticInfos, outputArguments);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CallMethodResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeStatusCodeArray("InputArgumentResults", value.getInputArgumentResults());
            encoder.writeDiagnosticInfoArray("InputArgumentDiagnosticInfos", value.getInputArgumentDiagnosticInfos());
            encoder.writeVariantArray("OutputArguments", value.getOutputArguments());
        }
    }
}

