/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control.tracing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.service.rpc.thrift.TSTracingInfo;
import org.apache.iotdb.tsfile.utils.Pair;

public class TracingInfo {
    private long startTime;
    private int seriesPathNum = 0;
    private final Set<TsFileResource> seqFileSet = new HashSet<TsFileResource>();
    private final Set<TsFileResource> unSeqFileSet = new HashSet<TsFileResource>();
    private int sequenceChunkNum = 0;
    private long sequenceChunkPointNum = 0L;
    private int unsequenceChunkNum = 0;
    private long unsequenceChunkPointNum = 0L;
    private int totalPageNum = 0;
    private int overlappedPageNum = 0;
    private final List<Pair<String, Long>> activityList = new ArrayList<Pair<String, Long>>();

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setSeriesPathNum(int seriesPathNum) {
        this.seriesPathNum = seriesPathNum;
    }

    public void addChunkInfo(int chunkNum, long pointNum, boolean isSeq) {
        if (isSeq) {
            this.sequenceChunkNum += chunkNum;
            this.sequenceChunkPointNum += pointNum;
        } else {
            this.unsequenceChunkNum += chunkNum;
            this.unsequenceChunkPointNum += pointNum;
        }
    }

    public int getSequenceChunkNum() {
        return this.sequenceChunkNum;
    }

    public long getSequenceChunkPoints() {
        return this.sequenceChunkPointNum;
    }

    public int getUnsequenceChunkNum() {
        return this.unsequenceChunkNum;
    }

    public long getUnsequenceChunkPoints() {
        return this.unsequenceChunkPointNum;
    }

    public Set<TsFileResource> getSeqFileSet() {
        return this.seqFileSet;
    }

    public Set<TsFileResource> getUnSeqFileSet() {
        return this.unSeqFileSet;
    }

    public void addTsFileSet(List<TsFileResource> seqResources, List<TsFileResource> unSeqResources) {
        this.seqFileSet.addAll(seqResources);
        this.unSeqFileSet.addAll(unSeqResources);
    }

    public void addTsFile(TsFileResource tsFileResource, boolean isSeq) {
        if (isSeq) {
            this.seqFileSet.add(tsFileResource);
        } else {
            this.unSeqFileSet.add(tsFileResource);
        }
    }

    public int getTotalPageNum() {
        return this.totalPageNum;
    }

    public int getOverlappedPageNum() {
        return this.overlappedPageNum;
    }

    public void addTotalPageNum(int totalPageNum) {
        this.totalPageNum += totalPageNum;
    }

    public void addOverlappedPageNum() {
        ++this.overlappedPageNum;
    }

    public void addActivity(String activity, long time) {
        this.activityList.add((Pair<String, Long>)new Pair((Object)activity, (Object)(time - this.startTime)));
    }

    public TSTracingInfo fillRpcReturnTracingInfo() {
        TSTracingInfo tsTracingInfo = new TSTracingInfo();
        ArrayList<String> activityList = new ArrayList<String>();
        ArrayList<Long> elapsedTimeList = new ArrayList<Long>();
        for (Pair<String, Long> pair : this.activityList) {
            String activity = (String)pair.left;
            long elapsedTime = (Long)pair.right;
            activityList.add(activity);
            elapsedTimeList.add(elapsedTime);
        }
        tsTracingInfo.setActivityList(activityList);
        tsTracingInfo.setElapsedTimeList(elapsedTimeList);
        tsTracingInfo.setSeriesPathNum(this.seriesPathNum);
        tsTracingInfo.setSeqFileNum(this.seqFileSet.size());
        tsTracingInfo.setUnSeqFileNum(this.unSeqFileSet.size());
        tsTracingInfo.setSequenceChunkNum(this.sequenceChunkNum);
        tsTracingInfo.setSequenceChunkPointNum(this.sequenceChunkPointNum);
        tsTracingInfo.setUnsequenceChunkNum(this.unsequenceChunkNum);
        tsTracingInfo.setUnsequenceChunkPointNum(this.unsequenceChunkPointNum);
        tsTracingInfo.setTotalPageNum(this.totalPageNum);
        tsTracingInfo.setOverlappedPageNum(this.overlappedPageNum);
        return tsTracingInfo;
    }
}

