/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.sink.local;

import java.util.Collections;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.trigger.sink.api.Handler;
import org.apache.iotdb.db.engine.trigger.sink.exception.SinkException;
import org.apache.iotdb.db.engine.trigger.sink.local.LocalIoTDBConfiguration;
import org.apache.iotdb.db.engine.trigger.sink.local.LocalIoTDBEvent;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class LocalIoTDBHandler
implements Handler<LocalIoTDBConfiguration, LocalIoTDBEvent> {
    private IPlanExecutor executor;
    private PartialPath device;
    private String[] measurements;
    private TSDataType[] dataTypes;

    @Override
    public void open(LocalIoTDBConfiguration configuration) throws Exception {
        this.executor = new PlanExecutor();
        this.device = configuration.getDevice();
        this.measurements = configuration.getMeasurements();
        this.dataTypes = configuration.getDataTypes();
        this.createOrCheckTimeseries();
    }

    private void createOrCheckTimeseries() throws MetadataException, SinkException {
        for (int i = 0; i < this.measurements.length; ++i) {
            String measurement = this.measurements[i];
            TSDataType dataType = this.dataTypes[i];
            PartialPath path = new PartialPath(this.device.getFullPath(), measurement);
            if (!IoTDB.metaManager.isPathExist(path)) {
                IoTDB.metaManager.createTimeseries(path, dataType, EncodingInferenceUtils.getDefaultEncoding(dataType), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
                continue;
            }
            if (IoTDB.metaManager.getSeriesType(path).equals((Object)dataType)) continue;
            throw new SinkException(String.format("The data type of %s you provided was not correct.", path));
        }
    }

    @Override
    public void onEvent(LocalIoTDBEvent event) throws QueryProcessException, StorageEngineException, StorageGroupNotSetException {
        InsertRowPlan plan = new InsertRowPlan();
        plan.setNeedInferType(false);
        plan.setDevicePath(this.device);
        plan.setMeasurements(this.measurements);
        plan.setDataTypes(this.dataTypes);
        plan.setTime(event.getTimestamp());
        plan.setValues(event.getValues());
        this.executeNonQuery(plan);
    }

    private void executeNonQuery(PhysicalPlan plan) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new QueryProcessException("Current system mode is read-only, non-query operation is not supported.");
        }
        this.executor.processNonQuery(plan);
    }
}

