/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.utils.MmapUtil;

public class StorageGroupInfo {
    private VirtualStorageGroupProcessor virtualStorageGroupProcessor;
    private AtomicLong memoryCost;
    private long storageGroupSizeReportThreshold = IoTDBDescriptor.getInstance().getConfig().getStorageGroupSizeReportThreshold();
    private AtomicLong lastReportedSize = new AtomicLong();
    private List<TsFileProcessor> reportedTsps = new CopyOnWriteArrayList<TsFileProcessor>();

    public StorageGroupInfo(VirtualStorageGroupProcessor virtualStorageGroupProcessor) {
        this.virtualStorageGroupProcessor = virtualStorageGroupProcessor;
        this.memoryCost = new AtomicLong();
    }

    public VirtualStorageGroupProcessor getVirtualStorageGroupProcessor() {
        return this.virtualStorageGroupProcessor;
    }

    public void initTsFileProcessorInfo(TsFileProcessor tsFileProcessor) {
        this.reportedTsps.add(tsFileProcessor);
    }

    public void addStorageGroupMemCost(long cost) {
        this.memoryCost.getAndAdd(cost);
    }

    public void releaseStorageGroupMemCost(long cost) {
        this.memoryCost.getAndAdd(-cost);
    }

    public long getMemCost() {
        return this.memoryCost.get();
    }

    public List<TsFileProcessor> getAllReportedTsp() {
        return this.reportedTsps;
    }

    public boolean needToReportToSystem() {
        return this.memoryCost.get() - this.lastReportedSize.get() > this.storageGroupSizeReportThreshold;
    }

    public void setLastReportedSize(long size) {
        this.lastReportedSize.set(size);
    }

    public void closeTsFileProcessorAndReportToSystem(TsFileProcessor tsFileProcessor) {
        this.reportedTsps.remove(tsFileProcessor);
        SystemInfo.getInstance().resetStorageGroupStatus(this);
    }

    public Supplier<ByteBuffer[]> getWalSupplier() {
        if (this.virtualStorageGroupProcessor != null) {
            return this.virtualStorageGroupProcessor::getWalDirectByteBuffer;
        }
        return this::walSupplier;
    }

    private ByteBuffer[] walSupplier() {
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
        return buffers;
    }

    public Consumer<ByteBuffer[]> getWalConsumer() {
        if (this.virtualStorageGroupProcessor != null) {
            return this.virtualStorageGroupProcessor::releaseWalBuffer;
        }
        return this::walConsumer;
    }

    private void walConsumer(ByteBuffer[] buffers) {
        for (ByteBuffer byteBuffer : buffers) {
            MmapUtil.clean((MappedByteBuffer)byteBuffer);
        }
    }
}

