/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.NodeSerializeUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.utils.SerializeUtils;

public class RemoteTsFileResource
extends TsFileResource {
    private Node source;
    private boolean isRemote = false;
    private boolean withModification = false;
    private boolean isPlanRangeUnique = false;

    public RemoteTsFileResource() {
        this.setStatus(TsFileResourceStatus.CLOSED);
        this.timeIndex = IoTDBDescriptor.getInstance().getConfig().getTimeIndexLevel().getTimeIndex();
    }

    private RemoteTsFileResource(TsFileResource other) throws IOException {
        super(other);
        this.withModification = new File(this.getModFile().getFilePath()).exists();
        this.setStatus(TsFileResourceStatus.CLOSED);
    }

    public RemoteTsFileResource(TsFileResource other, Node source) throws IOException {
        this(other);
        this.source = source;
        this.isRemote = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoteTsFileResource that = (RemoteTsFileResource)((Object)o);
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.source);
    }

    public void serialize(DataOutputStream dataOutputStream) {
        NodeSerializeUtils.serialize(this.source, dataOutputStream);
        try {
            SerializeUtils.serialize((String)this.getTsFile().getPath(), (DataOutputStream)dataOutputStream);
            this.timeIndex.serialize((OutputStream)dataOutputStream);
            dataOutputStream.writeBoolean(this.withModification);
            dataOutputStream.writeLong(this.maxPlanIndex);
            dataOutputStream.writeLong(this.minPlanIndex);
            dataOutputStream.writeByte(this.isPlanRangeUnique ? 1 : 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void deserialize(ByteBuffer buffer) {
        this.source = new Node();
        NodeSerializeUtils.deserialize(this.source, buffer);
        this.setFile(new File(SerializeUtils.deserializeString((ByteBuffer)buffer)));
        this.timeIndex = IoTDBDescriptor.getInstance().getConfig().getTimeIndexLevel().getTimeIndex().deserialize(buffer);
        this.withModification = buffer.get() == 1;
        this.maxPlanIndex = buffer.getLong();
        this.minPlanIndex = buffer.getLong();
        this.isPlanRangeUnique = buffer.get() == 1;
        this.isRemote = true;
    }

    public Node getSource() {
        return this.source;
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    public void setRemote(boolean remote) {
        this.isRemote = remote;
    }

    public boolean isWithModification() {
        return this.withModification;
    }

    public boolean isPlanRangeUnique() {
        return this.isPlanRangeUnique;
    }

    public void setPlanRangeUnique(boolean planRangeUnique) {
        this.isPlanRangeUnique = planRangeUnique;
    }
}

