/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.net.ConnectException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectionHandler
implements AsyncMethodCallback<Long> {
    private static final Logger logger = LoggerFactory.getLogger(ElectionHandler.class);
    private RaftMember raftMember;
    private String memberName;
    private Node voter;
    private long currTerm;
    private AtomicInteger requiredVoteNum;
    private AtomicBoolean terminated;
    private AtomicBoolean electionValid;
    private AtomicInteger failingVoteCounter;

    public ElectionHandler(RaftMember raftMember, Node voter, long currTerm, AtomicInteger requiredVoteNum, AtomicBoolean terminated, AtomicBoolean electionValid, AtomicInteger failingVoteCounter) {
        this.raftMember = raftMember;
        this.voter = voter;
        this.currTerm = currTerm;
        this.requiredVoteNum = requiredVoteNum;
        this.terminated = terminated;
        this.electionValid = electionValid;
        this.memberName = raftMember.getName();
        this.failingVoteCounter = failingVoteCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(Long resp) {
        long voterResp = resp;
        String result = "fail";
        AtomicLong atomicLong = this.raftMember.getTerm();
        synchronized (atomicLong) {
            if (this.terminated.get()) {
                logger.info("{}: Terminated election received a election response {} from {}", new Object[]{this.memberName, voterResp, this.voter});
                return;
            }
            if (voterResp == -1L) {
                long remaining = this.requiredVoteNum.decrementAndGet();
                logger.info("{}: Received a grant vote from {}, remaining votes to succeed: {}", new Object[]{this.memberName, this.voter, remaining});
                if (remaining == 0L) {
                    this.electionValid.set(true);
                    this.terminated.set(true);
                    this.raftMember.getTerm().notifyAll();
                    this.raftMember.onElectionWins();
                    result = "win";
                    logger.info("{}: Election {} is won", (Object)this.memberName, (Object)this.currTerm);
                }
            } else if (voterResp != -7L) {
                if (voterResp < this.currTerm) {
                    logger.info("{}: Election {} rejected: code {}", new Object[]{this.memberName, this.currTerm, voterResp});
                    this.onFail();
                } else if (voterResp == -11L) {
                    logger.info("{}: This node has removed from the group", (Object)this.memberName);
                    this.onFail();
                } else {
                    logger.info("{}: Election {} rejected from {}: The term of this node is no bigger than {}", new Object[]{this.memberName, this.currTerm, this.voter, voterResp});
                    this.raftMember.stepDown(voterResp, false);
                    this.terminated.set(true);
                    this.raftMember.getTerm().notifyAll();
                }
            }
        }
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricService.getInstance().count(1L, Metric.CLUSTER_ELECT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), this.raftMember.getThisNode().internalIp, Tag.STATUS.toString(), result});
        }
    }

    public void onError(Exception exception) {
        if (exception instanceof ConnectException) {
            logger.warn("{}: Cannot connect to {}: {}", new Object[]{this.memberName, this.voter, exception.getMessage()});
        } else {
            logger.warn("{}: A voter {} encountered an error:", new Object[]{this.memberName, this.voter, exception});
        }
        this.onFail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFail() {
        int failingVoteRemaining = this.failingVoteCounter.decrementAndGet();
        if (failingVoteRemaining <= 0) {
            AtomicLong atomicLong = this.raftMember.getTerm();
            synchronized (atomicLong) {
                this.raftMember.getTerm().notifyAll();
            }
        }
    }
}

