/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log;

import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitLogTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CommitLogTask.class);
    private RaftLogManager logManager;
    private long leaderCommit;
    private long term;
    private AsyncMethodCallback<Void> callback;

    public CommitLogTask(RaftLogManager logManager, long leaderCommit, long term) {
        this.logManager = logManager;
        this.leaderCommit = leaderCommit;
        this.term = term;
    }

    public void registerCallback(AsyncMethodCallback<Void> callback) {
        this.callback = callback;
    }

    private void doCommitLog() {
        if (this.callback == null) {
            logger.error("callback is not registered");
            return;
        }
        boolean success = this.logManager.maybeCommit(this.leaderCommit, this.term);
        if (success) {
            this.callback.onComplete(null);
        }
    }

    @Override
    public void run() {
        this.doCommitLog();
    }
}

