/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster;

import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.cluster.ClusterIoTDBMBean;
import org.apache.iotdb.cluster.client.ClientCategory;
import org.apache.iotdb.cluster.client.ClientManager;
import org.apache.iotdb.cluster.client.IClientManager;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.async.AsyncMetaClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterConfig;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.coordinator.Coordinator;
import org.apache.iotdb.cluster.exception.ConfigInconsistentException;
import org.apache.iotdb.cluster.exception.StartUpCheckFailureException;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.metadata.MetaPuller;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotStrategy;
import org.apache.iotdb.cluster.query.manage.ClusterSessionManager;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.ClusterRPCService;
import org.apache.iotdb.cluster.server.ClusterTSServiceImpl;
import org.apache.iotdb.cluster.server.HardLinkCleaner;
import org.apache.iotdb.cluster.server.basic.ClusterServiceProvider;
import org.apache.iotdb.cluster.server.clusterinfo.ClusterInfoServer;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.monitor.NodeReport;
import org.apache.iotdb.cluster.server.raft.DataRaftHeartBeatService;
import org.apache.iotdb.cluster.server.raft.DataRaftService;
import org.apache.iotdb.cluster.server.raft.MetaRaftHeartBeatService;
import org.apache.iotdb.cluster.server.raft.MetaRaftService;
import org.apache.iotdb.cluster.server.service.DataGroupEngine;
import org.apache.iotdb.cluster.server.service.DataGroupServiceImpls;
import org.apache.iotdb.cluster.server.service.MetaAsyncService;
import org.apache.iotdb.cluster.server.service.MetaSyncService;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitor;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBConfigCheck;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.ConfigurationException;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.RegisterManager;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.service.thrift.ThriftServiceThread;
import org.apache.thrift.TException;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterIoTDB
implements ClusterIoTDBMBean {
    private static final Logger logger = LoggerFactory.getLogger(ClusterIoTDB.class);
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.cluster.service", "type", "ClusterIoTDB");
    private boolean printClientConnectionErrorStack = false;
    private static final String MODE_START = "-s";
    private static final String MODE_ADD = "-a";
    private static final String MODE_REMOVE = "-r";
    private MetaGroupMember metaGroupMember;
    private DataGroupEngine dataGroupEngine;
    private Node thisNode;
    private Coordinator coordinator;
    private final IoTDB iotdb = IoTDB.getInstance();
    private final RegisterManager registerManager = new RegisterManager();
    private ScheduledExecutorService reportThread;
    private boolean allowReport = true;
    private ScheduledExecutorService hardLinkCleanerThread;
    private IClientManager clientManager;

    private ClusterIoTDB() {
    }

    public boolean initLocalEngines() {
        ClusterConfig config = ClusterDescriptor.getInstance().getConfig();
        this.thisNode = new Node();
        this.thisNode.setInternalIp(config.getInternalIp());
        this.thisNode.setMetaPort(config.getInternalMetaPort());
        this.thisNode.setDataPort(config.getInternalDataPort());
        this.thisNode.setClientPort(config.getClusterRpcPort());
        this.thisNode.setClientIp(IoTDBDescriptor.getInstance().getConfig().getRpcAddress());
        this.coordinator = new Coordinator();
        TProtocolFactory protocolFactory = ThriftServiceThread.getProtocolFactory((boolean)IoTDBDescriptor.getInstance().getConfig().isRpcThriftCompressionEnable());
        this.metaGroupMember = new MetaGroupMember(protocolFactory, this.thisNode, this.coordinator);
        IoTDB.setClusterMode();
        IoTDB.setMetaManager((MManager)CMManager.getInstance());
        ((CMManager)IoTDB.metaManager).setMetaGroupMember(this.metaGroupMember);
        ((CMManager)IoTDB.metaManager).setCoordinator(this.coordinator);
        MetaPuller.getInstance().init(this.metaGroupMember);
        try {
            IoTDB.setServiceProvider((ServiceProvider)new ClusterServiceProvider(this.coordinator, this.metaGroupMember));
        }
        catch (QueryProcessException e) {
            logger.error("Failed to set clusterServiceProvider.", (Throwable)e);
            this.stop();
            return false;
        }
        DataGroupEngine.setProtocolFactory(protocolFactory);
        DataGroupEngine.setMetaGroupMember(this.metaGroupMember);
        this.dataGroupEngine = DataGroupEngine.getInstance();
        this.clientManager = new ClientManager(ClusterDescriptor.getInstance().getConfig().isUseAsyncServer(), ClientManager.Type.RequestForwardClient);
        this.initTasks();
        try {
            this.startServerCheck();
            JMXService.registerMBean((Object)this.metaGroupMember, (String)this.metaGroupMember.getMBeanName());
        }
        catch (StartupException e) {
            logger.error("Failed to check cluster config.", (Throwable)e);
            this.stop();
            return false;
        }
        return true;
    }

    private void initTasks() {
        this.reportThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"NodeReportThread");
        this.reportThread.scheduleAtFixedRate(this::generateNodeReport, 10L, 10L, TimeUnit.SECONDS);
        this.hardLinkCleanerThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"HardLinkCleaner");
        this.hardLinkCleanerThread.scheduleAtFixedRate(new HardLinkCleaner(), 3600L, 3600L, TimeUnit.SECONDS);
    }

    private void generateNodeReport() {
        if (logger.isDebugEnabled() && this.allowReport) {
            try {
                NodeReport report = new NodeReport(this.thisNode);
                report.setMetaMemberReport(this.metaGroupMember.genMemberReport());
                report.setDataMemberReportList(this.dataGroupEngine.genMemberReports());
                logger.debug(report.toString());
            }
            catch (Exception e) {
                logger.error("exception occurred when generating node report", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            logger.error("Usage: <-s|-a|-r> [-D{} <configure folder>] \n-s: start the node as a seed\n-a: start the node as a new node\n-r: remove the node out of the cluster\n", (Object)"IOTDB_CONF");
            return;
        }
        ClusterIoTDB cluster = ClusterIoTDBHolder.INSTANCE;
        try {
            if (!cluster.serverCheckAndInit()) {
                return;
            }
        }
        catch (IOException | ConfigurationException e) {
            logger.error("meet error when doing start checking", e);
            return;
        }
        String mode = args[0];
        logger.info("Running mode {}", (Object)mode);
        if (!cluster.initLocalEngines()) {
            logger.error("initLocalEngines error, stop process!");
            return;
        }
        if (MODE_START.equals(mode)) {
            cluster.activeStartNodeMode();
        } else if (MODE_ADD.equals(mode)) {
            cluster.activeAddNodeMode();
        } else if (MODE_REMOVE.equals(mode)) {
            try {
                cluster.doRemoveNode(args);
            }
            catch (IOException e) {
                logger.error("Fail to remove node in cluster", (Throwable)e);
            }
        } else {
            logger.error("Unrecognized mode {}", (Object)mode);
        }
    }

    private boolean serverCheckAndInit() throws ConfigurationException, IOException {
        IoTDBConfigCheck.getInstance().checkConfig();
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        config.setSyncEnable(false);
        config.setAutoCreateSchemaEnabled(false);
        String checkResult = this.clusterConfigCheck();
        if (checkResult != null) {
            logger.error(checkResult);
            return false;
        }
        ClusterConfig clusterConfig = ClusterDescriptor.getInstance().getConfig();
        if (config.getRpcAddress().equals("0.0.0.0")) {
            config.setRpcAddress(clusterConfig.getInternalIp());
        }
        if (clusterConfig.getReplicationNum() > 1) {
            clusterConfig.setMaxMemorySizeForRaftLog((long)((double)config.getAllocateMemoryForStorageEngine() * clusterConfig.getRaftLogMemoryProportion() / (double)clusterConfig.getReplicationNum()));
            config.setAllocateMemoryForStorageEngine((long)((double)config.getAllocateMemoryForStorageEngine() * (1.0 - clusterConfig.getRaftLogMemoryProportion())));
        }
        return true;
    }

    private String clusterConfigCheck() {
        try {
            ClusterDescriptor.getInstance().replaceHostnameWithIp();
        }
        catch (Exception e) {
            return String.format("replace hostname with ip failed, %s", e.getMessage());
        }
        ClusterConfig config = ClusterDescriptor.getInstance().getConfig();
        if (config.getReplicationNum() <= 0) {
            return String.format("ReplicateNum should be greater than 0 instead of %d.", config.getReplicationNum());
        }
        int quorum = config.getReplicationNum() / 2 + 1;
        if (config.getSeedNodeUrls().size() < quorum) {
            return String.format("Seed number less than quorum, seed number: %s, quorum: %s.", config.getSeedNodeUrls().size(), quorum);
        }
        HashSet<Node> seedNodes = new HashSet<Node>();
        for (String url : config.getSeedNodeUrls()) {
            Node node = ClusterUtils.parseNode(url);
            if (seedNodes.contains(node)) {
                return String.format("SeedNodes must not repeat each other. SeedNodes: %s", config.getSeedNodeUrls());
            }
            seedNodes.add(node);
        }
        return null;
    }

    public void activeStartNodeMode() {
        try {
            IoTDB.getInstance().active();
            this.preInitCluster();
            this.metaGroupMember.buildCluster();
            this.postInitCluster();
            this.startClientRPC();
        }
        catch (ConfigInconsistentException | StartUpCheckFailureException | StartupException | QueryProcessException e) {
            logger.error("Fail to start  server", e);
            this.stop();
        }
    }

    private void preInitCluster() throws StartupException {
        this.stopRaftInfoReport();
        JMXService.registerMBean((Object)this, (String)this.mbeanName);
        this.registerManager.register((IService)this.metaGroupMember);
        this.registerManager.register((IService)this.dataGroupEngine);
        DataGroupServiceImpls dataGroupServiceImpls = new DataGroupServiceImpls();
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            MetaAsyncService metaAsyncService = new MetaAsyncService(this.metaGroupMember);
            MetaRaftHeartBeatService.getInstance().initAsyncedServiceImpl(metaAsyncService);
            MetaRaftService.getInstance().initAsyncedServiceImpl(metaAsyncService);
            DataRaftService.getInstance().initAsyncedServiceImpl(dataGroupServiceImpls);
            DataRaftHeartBeatService.getInstance().initAsyncedServiceImpl(dataGroupServiceImpls);
        } else {
            MetaSyncService syncService = new MetaSyncService(this.metaGroupMember);
            MetaRaftHeartBeatService.getInstance().initSyncedServiceImpl(syncService);
            MetaRaftService.getInstance().initSyncedServiceImpl(syncService);
            DataRaftService.getInstance().initSyncedServiceImpl(dataGroupServiceImpls);
            DataRaftHeartBeatService.getInstance().initSyncedServiceImpl(dataGroupServiceImpls);
        }
        logger.info("start Meta Heartbeat RPC service... ");
        this.registerManager.register((IService)MetaRaftHeartBeatService.getInstance());
        logger.info("start Meta RPC service... ");
        this.registerManager.register((IService)MetaRaftService.getInstance());
    }

    private void postInitCluster() throws StartupException {
        logger.info("start Data Heartbeat RPC service... ");
        this.registerManager.register((IService)DataRaftHeartBeatService.getInstance());
        logger.info("start Data RPC service... ");
        this.registerManager.register((IService)DataRaftService.getInstance());
        this.registerManager.register((IService)ClusterInfoServer.getInstance());
        this.registerManager.register((IService)ClusterMonitor.INSTANCE);
    }

    private void startClientRPC() throws QueryProcessException, StartupException {
        ClusterTSServiceImpl clusterServiceImpl = new ClusterTSServiceImpl();
        ServiceProvider.SESSION_MANAGER = ClusterSessionManager.getInstance();
        ClusterSessionManager.getInstance().setCoordinator(this.coordinator);
        ClusterRPCService.getInstance().initSyncedServiceImpl((Object)clusterServiceImpl);
        this.registerManager.register((IService)ClusterRPCService.getInstance());
        if (IoTDBDescriptor.getInstance().getConfig().isEnableInfluxDBRpcService()) {
            IoTDB.initInfluxDBMManager();
        }
    }

    public void activeAddNodeMode() {
        try {
            long startTime = System.currentTimeMillis();
            this.preInitCluster();
            this.metaGroupMember.joinCluster();
            this.postInitCluster();
            this.dataGroupEngine.pullSnapshots();
            this.startClientRPC();
            logger.info("Adding this node {} to cluster costs {} ms", (Object)this.thisNode, (Object)(System.currentTimeMillis() - startTime));
        }
        catch (ConfigInconsistentException | StartUpCheckFailureException | StartupException | QueryProcessException e) {
            this.stop();
            logger.error("Fail to join cluster", e);
        }
    }

    private void startServerCheck() throws StartupException {
        String message;
        ClusterConfig config = ClusterDescriptor.getInstance().getConfig();
        HashSet<Node> seedNodes = new HashSet<Node>();
        for (String url : config.getSeedNodeUrls()) {
            Node node = ClusterUtils.parseNode(url);
            if (seedNodes.contains(node)) {
                String message2 = String.format("SeedNodes must not repeat each other. SeedNodes: %s", config.getSeedNodeUrls());
                throw new StartupException(this.metaGroupMember.getName(), message2);
            }
            seedNodes.add(node);
        }
        if (!this.metaGroupMember.getAllNodes().isEmpty()) {
            if (!this.metaGroupMember.getAllNodes().contains(this.metaGroupMember.getThisNode())) {
                message = String.format("All nodes in partitionTables must contains local node in start-server mode. LocalNode: %s, AllNodes: %s", this.metaGroupMember.getThisNode(), this.metaGroupMember.getAllNodes());
                throw new StartupException(this.metaGroupMember.getName(), message);
            }
            return;
        }
        if (!seedNodes.contains(this.thisNode)) {
            message = String.format("SeedNodes must contains local node in start-server mode. LocalNode: %s ,SeedNodes: %s", this.thisNode.toString(), config.getSeedNodeUrls());
            throw new StartupException(this.metaGroupMember.getName(), message);
        }
    }

    private void doRemoveNode(String[] args) throws IOException {
        if (args.length != 3) {
            logger.error("Usage: <ip> <metaPort>");
            return;
        }
        String ip = args[1];
        int metaPort = Integer.parseInt(args[2]);
        ClusterConfig config = ClusterDescriptor.getInstance().getConfig();
        TCompactProtocol.Factory factory = config.isRpcThriftCompressionEnabled() ? new TCompactProtocol.Factory() : new TBinaryProtocol.Factory();
        Node nodeToRemove = new Node();
        nodeToRemove.setInternalIp(ip).setMetaPort(metaPort).setClientIp("UNKNOWN_IP");
        for (String url : config.getSeedNodeUrls()) {
            Node node = ClusterUtils.parseNode(url);
            if (node == null) continue;
            AsyncMetaClient client = new AsyncMetaClient((TProtocolFactory)factory, new TAsyncClientManager(), node, ClientCategory.META);
            Long response = null;
            long startTime = System.currentTimeMillis();
            try {
                logger.info("Start removing node {} with the help of node {}", (Object)nodeToRemove, (Object)node);
                response = SyncClientAdaptor.removeNode(client, nodeToRemove);
            }
            catch (TException e) {
                logger.warn("Cannot send remove node request through {}, try next node", (Object)node);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Cannot send remove node request through {}, try next node", (Object)node);
            }
            if (response == null) continue;
            this.handleNodeRemovalResp(response, nodeToRemove, startTime);
            return;
        }
    }

    private void handleNodeRemovalResp(Long response, Node nodeToRemove, long startTime) {
        if (response == -1L) {
            logger.info("Node {} is successfully removed, cost {}ms", (Object)nodeToRemove, (Object)(System.currentTimeMillis() - startTime));
        } else if (response == -8L) {
            logger.error("Cluster size is too small, cannot remove any node");
        } else if (response == -3L) {
            logger.error("Node {} is not found in the cluster, please check", (Object)nodeToRemove);
        } else if (response == -10L) {
            logger.warn("The data migration of the previous membership change operation is not finished. Please try again later");
        } else {
            logger.error("Unexpected response {}", (Object)response);
        }
    }

    private void preStartCustomize() {
        SlotPartitionTable.setSlotStrategy(new SlotStrategy(){
            final SlotStrategy defaultStrategy = new SlotStrategy.DefaultStrategy();
            final int clusterSize = ClusterDescriptor.getInstance().getConfig().getSeedNodeUrls().size();

            @Override
            public int calculateSlotByTime(String storageGroupName, long timestamp, int maxSlotNum) {
                int sgSerialNum = this.extractSerialNumInSGName(storageGroupName) % this.clusterSize;
                if (sgSerialNum >= 0) {
                    return maxSlotNum / this.clusterSize * sgSerialNum;
                }
                return this.defaultStrategy.calculateSlotByTime(storageGroupName, timestamp, maxSlotNum);
            }

            @Override
            public int calculateSlotByPartitionNum(String storageGroupName, long partitionId, int maxSlotNum) {
                int sgSerialNum = this.extractSerialNumInSGName(storageGroupName) % this.clusterSize;
                if (sgSerialNum >= 0) {
                    return maxSlotNum / this.clusterSize * sgSerialNum;
                }
                return this.defaultStrategy.calculateSlotByPartitionNum(storageGroupName, partitionId, maxSlotNum);
            }

            private int extractSerialNumInSGName(String storageGroupName) {
                String[] s = storageGroupName.split("_");
                if (s.length != 2) {
                    return -1;
                }
                try {
                    return Integer.parseInt(s[1]);
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
        });
    }

    public void stop() {
        this.deactivate();
    }

    private void deactivate() {
        logger.info("Deactivating Cluster IoTDB...");
        this.stopThreadPools();
        this.registerManager.deregisterAll();
        JMXService.deregisterMBean((String)this.mbeanName);
        logger.info("ClusterIoTDB is deactivated.");
        this.iotdb.stop();
    }

    private void stopThreadPools() {
        this.stopThreadPool(this.reportThread, "reportThread");
        this.stopThreadPool(this.hardLinkCleanerThread, "hardLinkCleanerThread");
    }

    private void stopThreadPool(ExecutorService pool, String name) {
        if (pool != null) {
            pool.shutdownNow();
            try {
                pool.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected interruption when waiting for {} to end", (Object)name, (Object)e);
            }
        }
    }

    public void setClientManager(IClientManager clientManager) {
        this.clientManager = clientManager;
    }

    public IClientManager getClientManager() {
        return this.clientManager;
    }

    public void setDataGroupEngine(DataGroupEngine dataGroupEngine) {
        this.dataGroupEngine = dataGroupEngine;
    }

    public MetaGroupMember getMetaGroupMember() {
        return this.metaGroupMember;
    }

    public Node getThisNode() {
        return this.thisNode;
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public IoTDB getIotdb() {
        return this.iotdb;
    }

    public RegisterManager getRegisterManager() {
        return this.registerManager;
    }

    public DataGroupEngine getDataGroupEngine() {
        return this.dataGroupEngine;
    }

    public void setMetaGroupMember(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
    }

    public static ClusterIoTDB getInstance() {
        return ClusterIoTDBHolder.INSTANCE;
    }

    @Override
    public boolean startRaftInfoReport() {
        logger.info("Raft status report is enabled.");
        this.allowReport = true;
        return logger.isDebugEnabled();
    }

    @Override
    public void stopRaftInfoReport() {
        logger.info("Raft status report is disabled.");
        this.allowReport = false;
    }

    @Override
    public void enablePrintClientConnectionErrorStack() {
        this.printClientConnectionErrorStack = true;
    }

    @Override
    public void disablePrintClientConnectionErrorStack() {
        this.printClientConnectionErrorStack = false;
    }

    public boolean shouldPrintClientConnectionErrorStack() {
        return this.printClientConnectionErrorStack;
    }

    public SyncDataClient getSyncDataClient(Node node, int readOperationTimeoutMS) throws IOException {
        SyncDataClient dataClient = (SyncDataClient)this.clientManager.borrowSyncClient(node, ClientCategory.DATA);
        if (dataClient != null) {
            dataClient.setTimeout(readOperationTimeoutMS);
        }
        return dataClient;
    }

    public AsyncDataClient getAsyncDataClient(Node node, int readOperationTimeoutMS) throws IOException {
        AsyncDataClient dataClient = (AsyncDataClient)this.clientManager.borrowAsyncClient(node, ClientCategory.DATA);
        if (dataClient != null) {
            dataClient.setTimeout(readOperationTimeoutMS);
        }
        return dataClient;
    }

    private static class ClusterIoTDBHolder {
        private static final ClusterIoTDB INSTANCE = new ClusterIoTDB();

        private ClusterIoTDBHolder() {
        }
    }
}

