/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.reporter.InternalIoTDBReporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.session.util.SessionUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBInternalReporter
extends InternalIoTDBReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBInternalReporter.class);
    private Future<?> currentServiceFuture;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    protected void writeMetricToIoTDB(Map<String, Object> valueMap, String prefix, long time) {
        try {
            TSInsertRecordReq request = new TSInsertRecordReq();
            ArrayList<String> measurements = new ArrayList<String>();
            ArrayList<TSDataType> types = new ArrayList<TSDataType>();
            ArrayList<Object> values = new ArrayList<Object>();
            for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                String measurement = entry.getKey();
                Object value = entry.getValue();
                measurements.add(measurement);
                types.add(this.inferType(value));
                values.add(value);
            }
            ByteBuffer buffer = SessionUtils.getValueBuffer(types, values);
            request.setPrefixPath(prefix);
            request.setTimestamp(time);
            request.setMeasurements(measurements);
            request.setValues(buffer);
            request.setIsAligned(false);
            InsertRowPlan plan = new InsertRowPlan(new PartialPath(request.getPrefixPath()), request.getTimestamp(), request.getMeasurements().toArray(new String[0]), request.values, request.isAligned);
            if (!IoTDB.serviceProvider.executeNonQuery(plan)) {
                LOGGER.error("Failed to update the value of metric with status.");
            }
        }
        catch (IoTDBConnectionException e1) {
            LOGGER.error("Failed to update the value of metric because of unknown type", (Throwable)e1);
        }
        catch (StorageEngineException | IllegalPathException | StorageGroupNotSetException | QueryProcessException e2) {
            LOGGER.error("Failed to update the value of metric because of internal error", (Throwable)e2);
        }
    }

    protected void writeMetricsToIoTDB(Map<String, Map<String, Object>> valueMap, long time) {
        for (Map.Entry<String, Map<String, Object>> value : valueMap.entrySet()) {
            this.writeMetricToIoTDB(value.getValue(), value.getKey(), time);
        }
    }

    public boolean start() {
        if (this.currentServiceFuture == null) {
            this.currentServiceFuture = this.service.scheduleAtFixedRate(() -> this.writeMetricToIoTDB(this.autoGauges), 1L, MetricConfigDescriptor.getInstance().getMetricConfig().getAsyncCollectPeriodInSecond().intValue(), TimeUnit.SECONDS);
        }
        return true;
    }

    public boolean stop() {
        if (this.currentServiceFuture != null) {
            this.currentServiceFuture.cancel(true);
            this.currentServiceFuture = null;
        }
        this.clear();
        return true;
    }

    public ReporterType getReporterType() {
        return ReporterType.IOTDB;
    }

    public void setMetricManager(AbstractMetricManager metricManager) {
    }
}

