/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.expression.ResultColumn;
import org.apache.iotdb.db.query.expression.unary.FunctionExpression;
import org.apache.iotdb.db.query.expression.unary.TimeSeriesOperand;

public class SelectComponent {
    private final ZoneId zoneId;
    private boolean hasPlainAggregationFunction = false;
    private boolean hasTimeSeriesGeneratingFunction = false;
    private boolean hasUserDefinedAggregationFunction = false;
    protected List<ResultColumn> resultColumns = new ArrayList<ResultColumn>();
    private List<PartialPath> pathsCache;
    private List<String> aggregationFunctionsCache;

    public SelectComponent(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public SelectComponent(SelectComponent selectComponent) {
        this.zoneId = selectComponent.zoneId;
        this.hasPlainAggregationFunction = selectComponent.hasPlainAggregationFunction;
        this.hasTimeSeriesGeneratingFunction = selectComponent.hasTimeSeriesGeneratingFunction;
        this.hasUserDefinedAggregationFunction = selectComponent.hasUserDefinedAggregationFunction;
        this.resultColumns.addAll(selectComponent.resultColumns);
        this.pathsCache = null;
        this.aggregationFunctionsCache = null;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setHasPlainAggregationFunction(boolean hasPlainAggregationFunction) {
        this.hasPlainAggregationFunction = hasPlainAggregationFunction;
    }

    public boolean hasPlainAggregationFunction() {
        return this.hasPlainAggregationFunction;
    }

    public boolean hasTimeSeriesGeneratingFunction() {
        return this.hasTimeSeriesGeneratingFunction;
    }

    public boolean hasUserDefinedAggregationFunction() {
        return this.hasUserDefinedAggregationFunction;
    }

    public void addResultColumn(ResultColumn resultColumn) {
        this.resultColumns.add(resultColumn);
        if (resultColumn.getExpression().isUserDefinedAggregationFunctionExpression()) {
            this.hasUserDefinedAggregationFunction = true;
        }
        if (resultColumn.getExpression().isPlainAggregationFunctionExpression()) {
            this.hasPlainAggregationFunction = true;
        }
        if (resultColumn.getExpression().isTimeSeriesGeneratingFunctionExpression()) {
            this.hasTimeSeriesGeneratingFunction = true;
        }
    }

    public void setResultColumns(List<ResultColumn> resultColumns) {
        this.resultColumns = resultColumns;
        this.pathsCache = null;
        this.aggregationFunctionsCache = null;
    }

    public List<ResultColumn> getResultColumns() {
        return this.resultColumns;
    }

    public List<PartialPath> getPaths() {
        if (this.pathsCache == null) {
            this.pathsCache = new ArrayList<PartialPath>();
            for (ResultColumn resultColumn : this.resultColumns) {
                Expression expression = resultColumn.getExpression();
                if (expression instanceof TimeSeriesOperand) {
                    this.pathsCache.add(((TimeSeriesOperand)expression).getPath());
                    continue;
                }
                if (expression instanceof FunctionExpression && expression.isPlainAggregationFunctionExpression()) {
                    this.pathsCache.add(((TimeSeriesOperand)((FunctionExpression)expression).getExpressions().get(0)).getPath());
                    continue;
                }
                this.pathsCache.add(null);
            }
        }
        return this.pathsCache;
    }

    public List<String> getAggregationFunctions() {
        if (this.aggregationFunctionsCache == null) {
            this.aggregationFunctionsCache = new ArrayList<String>();
            for (ResultColumn resultColumn : this.resultColumns) {
                Expression expression = resultColumn.getExpression();
                this.aggregationFunctionsCache.add(expression instanceof FunctionExpression ? ((FunctionExpression)resultColumn.getExpression()).getFunctionName() : null);
            }
        }
        return this.aggregationFunctionsCache;
    }
}

