<!--

  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

-->

# Contributing
As a contributor, you can help shape the future of the project by providing feedback, joining our mailing lists, reporting bugs, requesting features, and participating in discussions. As you become more involved, you can also help with development by providing patches for bug fixes or features and helping to improve our documentation.

If you show sustained commitment to the project, you may be invited to become a committer. This brings with it the privilege of write access to the project repository and resources.

To learn more about how to get involved with the Apache Wayang project, please visit our “Get Involved” [page](https://wayang.apache.org/community/) and read the [Apache code of conduct](https://www.apache.org/foundation/policies/conduct.html). We look forward to your contributions!


## Contributing Workflow
Main steps include:

1. Send an email to the development list to introduce yourself and discuss what you plan to implement.

2. Fork the repository and implement your changes. Make sure all builds and tests are passing before going to step 3.

3. Open a Pull Request (PR).

4. Work with the code reviewer to apply any recommended changes.

5. Once the reviewer approves it, your PR is merged!

## Wayang Branch Strategy
All new code is under the `main` branch. Please, use this branch when forking this repo.

Before opening a Pull Request(PR), make sure the builds and tests are passing on your local environment.

### Release
The eligible code will be included in a release branch and properly tagged.


