/*
 * Decompiled with CFR 0.152.
 */
package zmq.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import zmq.Msg;
import zmq.ZMQ;
import zmq.util.Wire;

public class Metadata {
    public static final String IDENTITY = "Identity";
    public static final String SOCKET_TYPE = "Socket-Type";
    public static final String USER_ID = "User-Id";
    public static final String PEER_ADDRESS = "Peer-Address";
    private final Properties dictionary = new Properties();

    public Metadata() {
    }

    public Metadata(Properties dictionary) {
        this.dictionary.putAll((Map<?, ?>)dictionary);
    }

    public final Set<String> keySet() {
        return this.dictionary.stringPropertyNames();
    }

    public final void remove(String key) {
        this.dictionary.remove(key);
    }

    public final String get(String key) {
        return this.dictionary.getProperty(key);
    }

    public final void set(String key, String value) {
        this.dictionary.setProperty(key, value);
    }

    public int hashCode() {
        return this.dictionary.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)other;
        return this.dictionary.equals(that.dictionary);
    }

    public final void set(Metadata zapProperties) {
        this.dictionary.putAll((Map<?, ?>)zapProperties.dictionary);
    }

    public final boolean isEmpty() {
        return this.dictionary.isEmpty();
    }

    public String toString() {
        return "Metadata=" + this.dictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] bytes() {
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream(this.size());
        try {
            this.write(stream2);
            byte[] byArray = stream2.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            try {
                stream2.close();
            }
            catch (IOException iOException) {}
        }
    }

    private int size() {
        int size = 0;
        for (Map.Entry<Object, Object> entry : this.dictionary.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            ++size;
            size += key.length();
            size += 4;
            size += value.length();
        }
        return size;
    }

    public final void write(OutputStream stream2) throws IOException {
        for (Map.Entry<Object, Object> entry : this.dictionary.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            stream2.write(key.length());
            stream2.write(key.getBytes(ZMQ.CHARSET));
            stream2.write(Wire.putUInt32(value.length()));
            stream2.write(value.getBytes(ZMQ.CHARSET));
        }
    }

    public final int read(Msg msg, int offset, ParseListener listener) {
        return this.read(msg.buf(), offset, listener);
    }

    public final int read(ByteBuffer msg, int offset, ParseListener listener) {
        int bytesLeft;
        int valueLength;
        ByteBuffer data = msg.duplicate();
        data.position(offset);
        int index = offset;
        for (bytesLeft = data.remaining(); bytesLeft > 1; bytesLeft -= valueLength) {
            int rc;
            byte nameLength = data.get(index);
            ++index;
            if (--bytesLeft < nameLength) break;
            String name = new String(this.bytes(data, index, nameLength), ZMQ.CHARSET);
            index += nameLength;
            if ((bytesLeft -= nameLength) < 4) break;
            valueLength = Wire.getUInt32(data, index);
            index += 4;
            if ((bytesLeft -= 4) < valueLength) break;
            byte[] value = this.bytes(data, index, valueLength);
            String valueAsString = new String(value, ZMQ.CHARSET);
            index += valueLength;
            if (listener != null && (rc = listener.parsed(name, value, valueAsString)) != 0) {
                return rc;
            }
            this.set(name, valueAsString);
        }
        if (bytesLeft > 0) {
            return 156384820;
        }
        return 0;
    }

    private byte[] bytes(ByteBuffer buf, int position, int length) {
        byte[] bytes = new byte[length];
        int current = buf.position();
        buf.position(position);
        buf.get(bytes, 0, length);
        buf.position(current);
        return bytes;
    }

    public static interface ParseListener {
        public int parsed(String var1, byte[] var2, String var3);
    }
}

