/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.coder;

import java.nio.ByteBuffer;
import zmq.Msg;
import zmq.io.coder.IEncoder;
import zmq.util.Errno;
import zmq.util.ValueReference;

public abstract class EncoderBase
implements IEncoder {
    private ByteBuffer writeBuf;
    private Runnable next;
    private boolean newMsgFlag;
    private int toWrite;
    private final ByteBuffer buffer;
    private final int bufferSize;
    private boolean error;
    protected Msg inProgress;
    private final Errno errno;

    protected EncoderBase(Errno errno, int bufferSize) {
        this.errno = errno;
        this.bufferSize = bufferSize;
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.error = false;
    }

    @Override
    public final void loadMsg(Msg msg) {
        assert (this.inProgress == null);
        this.inProgress = msg;
        this.next();
    }

    @Override
    public final int encode(ValueReference<ByteBuffer> data, int size2) {
        int bufferSize = size2;
        ByteBuffer buf = data.get();
        if (buf == null) {
            buf = this.buffer;
            bufferSize = this.bufferSize;
            this.buffer.clear();
        }
        if (this.inProgress == null) {
            return 0;
        }
        int pos = 0;
        buf.limit(buf.capacity());
        while (pos < bufferSize) {
            if (this.toWrite == 0) {
                if (this.newMsgFlag) {
                    this.inProgress = null;
                    break;
                }
                this.next();
            }
            if (pos == 0 && data.get() == null && this.toWrite >= bufferSize) {
                this.writeBuf.limit(this.writeBuf.capacity());
                data.set(this.writeBuf);
                pos = this.toWrite;
                this.writeBuf = null;
                this.toWrite = 0;
                return pos;
            }
            int toCopy = Math.min(this.toWrite, bufferSize - pos);
            int limit2 = this.writeBuf.limit();
            this.writeBuf.limit(Math.min(this.writeBuf.capacity(), this.writeBuf.position() + toCopy));
            int current = buf.position();
            buf.put(this.writeBuf);
            toCopy = buf.position() - current;
            this.writeBuf.limit(limit2);
            pos += toCopy;
            this.toWrite -= toCopy;
        }
        data.set(buf);
        return pos;
    }

    protected void encodingError() {
        this.error = true;
    }

    public final boolean isError() {
        return this.error;
    }

    protected void next() {
        if (this.next != null) {
            this.next.run();
        }
    }

    protected void nextStep(Msg msg, Runnable state2, boolean beginning) {
        if (msg == null) {
            this.nextStep((byte[])null, 0, state2, beginning);
        } else {
            this.nextStep(msg.buf(), state2, beginning);
        }
    }

    private void nextStep(byte[] buf, int toWrite, Runnable next2, boolean newMsgFlag) {
        if (buf != null) {
            this.writeBuf = ByteBuffer.wrap(buf);
            this.writeBuf.limit(toWrite);
        } else {
            this.writeBuf = null;
        }
        this.toWrite = toWrite;
        this.next = next2;
        this.newMsgFlag = newMsgFlag;
    }

    protected void initStep(Runnable next2, boolean newMsgFlag) {
        this.nextStep((byte[])null, 0, next2, newMsgFlag);
    }

    private void nextStep(ByteBuffer buf, Runnable next2, boolean newMsgFlag) {
        this.nextStep(buf, buf.limit(), next2, newMsgFlag);
    }

    protected void nextStep(ByteBuffer buf, int toWrite, Runnable next2, boolean newMsgFlag) {
        buf.limit(toWrite);
        buf.position(toWrite);
        buf.flip();
        this.writeBuf = buf;
        this.toWrite = toWrite;
        this.next = next2;
        this.newMsgFlag = newMsgFlag;
    }

    public int errno() {
        return this.errno.get();
    }

    public void errno(int err2) {
        this.errno.set(err2);
    }

    @Override
    public void destroy() {
    }
}

