/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.log;

import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.springframework.lang.Nullable;

public abstract class LogFormatUtils {
    public static String formatValue(@Nullable Object value2, boolean limitLength) {
        String str;
        if (value2 == null) {
            return "";
        }
        if (value2 instanceof CharSequence) {
            str = "\"" + value2 + "\"";
        } else {
            try {
                str = value2.toString();
            }
            catch (Throwable ex) {
                str = ex.toString();
            }
        }
        return limitLength && str.length() > 100 ? str.substring(0, 100) + " (truncated)..." : str;
    }

    public static void traceDebug(Log logger, Function<Boolean, String> messageFactory) {
        if (logger.isDebugEnabled()) {
            boolean traceEnabled = logger.isTraceEnabled();
            String logMessage = messageFactory.apply(traceEnabled);
            if (traceEnabled) {
                logger.trace(logMessage);
            } else {
                logger.debug(logMessage);
            }
        }
    }
}

