/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true)
final class ExplicitOrdering<T>
extends Ordering<T>
implements Serializable {
    final ImmutableMap<T, Integer> rankMap;
    private static final long serialVersionUID = 0L;

    ExplicitOrdering(List<T> valuesInOrder) {
        this(ExplicitOrdering.buildRankMap(valuesInOrder));
    }

    ExplicitOrdering(ImmutableMap<T, Integer> rankMap) {
        this.rankMap = rankMap;
    }

    @Override
    public int compare(T left2, T right2) {
        return this.rank(left2) - this.rank(right2);
    }

    private int rank(T value2) {
        Integer rank = this.rankMap.get(value2);
        if (rank == null) {
            throw new Ordering.IncomparableValueException(value2);
        }
        return rank;
    }

    private static <T> ImmutableMap<T, Integer> buildRankMap(List<T> valuesInOrder) {
        ImmutableMap.Builder<T, Integer> builder = ImmutableMap.builder();
        int rank = 0;
        for (T value2 : valuesInOrder) {
            builder.put(value2, rank++);
        }
        return builder.build();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof ExplicitOrdering) {
            ExplicitOrdering that2 = (ExplicitOrdering)object;
            return this.rankMap.equals(that2.rankMap);
        }
        return false;
    }

    public int hashCode() {
        return this.rankMap.hashCode();
    }

    public String toString() {
        return "Ordering.explicit(" + this.rankMap.keySet() + ")";
    }
}

