/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.util.Unsafe;

public abstract class AbstractBoundedNodeQueue<T> {
    private final int capacity;
    private volatile Node<T> _enqDoNotCallMeDirectly;
    private volatile Node<T> _deqDoNotCallMeDirectly;
    private static final long enqOffset;
    private static final long deqOffset;

    protected AbstractBoundedNodeQueue(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("AbstractBoundedNodeQueue.capacity must be >= 0");
        }
        this.capacity = n;
        Node node4 = new Node();
        this.setDeq(node4);
        this.setEnq(node4);
    }

    private final void setEnq(Node<T> node4) {
        Unsafe.instance.putObjectVolatile(this, enqOffset, node4);
    }

    private final Node<T> getEnq() {
        return (Node)Unsafe.instance.getObjectVolatile(this, enqOffset);
    }

    private final boolean casEnq(Node<T> node4, Node<T> node5) {
        return Unsafe.instance.compareAndSwapObject(this, enqOffset, node4, node5);
    }

    private final void setDeq(Node<T> node4) {
        Unsafe.instance.putObjectVolatile(this, deqOffset, node4);
    }

    private final Node<T> getDeq() {
        return (Node)Unsafe.instance.getObjectVolatile(this, deqOffset);
    }

    private final boolean casDeq(Node<T> node4, Node<T> node5) {
        return Unsafe.instance.compareAndSwapObject(this, deqOffset, node4, node5);
    }

    protected final Node<T> peekNode() {
        Node<T> node4;
        Node<T> node5;
        while ((node5 = (node4 = this.getDeq()).next()) == null && this.getEnq() != node4) {
        }
        return node5;
    }

    public final T peek() {
        Node<T> node4 = this.peekNode();
        return node4 != null ? (T)node4.value : null;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final boolean add(T t) {
        block2: {
            Node node4;
            Node node5 = null;
            do {
                node4 = this.getEnq();
                int n = node4.count;
                if (n - this.getDeq().count >= this.capacity) break block2;
                if (node5 == null) {
                    node5 = new Node();
                    node5.value = t;
                }
                node5.count = n + 1;
            } while (!this.casEnq(node4, node5));
            node4.setNext(node5);
            return true;
        }
        return false;
    }

    public final boolean addNode(Node<T> node4) {
        block1: {
            Node node5;
            node4.setNext(null);
            do {
                node5 = this.getEnq();
                int n = node5.count;
                if (n - this.getDeq().count >= this.capacity) break block1;
                node4.count = n + 1;
            } while (!this.casEnq(node5, node4));
            node5.setNext(node4);
            return true;
        }
        return false;
    }

    public final boolean isEmpty() {
        return this.getEnq() == this.getDeq();
    }

    public final int size() {
        int n;
        int n2;
        int n3;
        do {
            n2 = this.getDeq().count;
            n = this.getEnq().count;
        } while ((n3 = this.getDeq().count) != n2);
        return n - n3;
    }

    public final T poll() {
        Node<T> node4 = this.pollNode();
        return node4 != null ? (T)node4.value : null;
    }

    public final Node<T> pollNode() {
        while (true) {
            Node node4;
            Node<T> node5;
            if ((node5 = (node4 = this.getDeq()).next()) != null) {
                if (!this.casDeq(node4, node5)) continue;
                node4.value = node5.value;
                node4.setNext(null);
                node5.value = null;
                return node4;
            }
            if (this.getEnq() == node4) break;
        }
        return null;
    }

    static {
        try {
            enqOffset = Unsafe.instance.objectFieldOffset(AbstractBoundedNodeQueue.class.getDeclaredField("_enqDoNotCallMeDirectly"));
            deqOffset = Unsafe.instance.objectFieldOffset(AbstractBoundedNodeQueue.class.getDeclaredField("_deqDoNotCallMeDirectly"));
        }
        catch (Throwable throwable2) {
            throw new ExceptionInInitializerError(throwable2);
        }
    }

    public static class Node<T> {
        protected T value;
        private volatile Node<T> _nextDoNotCallMeDirectly;
        protected int count;
        private static final long nextOffset;

        public final Node<T> next() {
            return (Node)Unsafe.instance.getObjectVolatile(this, nextOffset);
        }

        protected final void setNext(Node<T> node4) {
            Unsafe.instance.putOrderedObject(this, nextOffset, node4);
        }

        static {
            try {
                nextOffset = Unsafe.instance.objectFieldOffset(Node.class.getDeclaredField("_nextDoNotCallMeDirectly"));
            }
            catch (Throwable throwable2) {
                throw new ExceptionInInitializerError(throwable2);
            }
        }
    }
}

