/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.options;

import com.google.common.base.Preconditions;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.options.OptionsUtil;
import java.util.Optional;

public final class GetOption {
    public static final GetOption DEFAULT = GetOption.newBuilder().build();
    private final Optional<ByteSequence> endKey;
    private final long limit;
    private final long revision;
    private final SortOrder sortOrder;
    private final SortTarget sortTarget;
    private final boolean serializable;
    private final boolean keysOnly;
    private final boolean countOnly;
    private final long minCreateRevision;
    private final long maxCreateRevision;
    private final long minModRevision;
    private final long maxModRevision;

    public static Builder newBuilder() {
        return new Builder();
    }

    private GetOption(Optional<ByteSequence> endKey, long limit, long revision, SortOrder sortOrder, SortTarget sortTarget, boolean serializable, boolean keysOnly, boolean countOnly, long minCreateRevision, long maxCreateRevision, long minModRevision, long maxModRevision) {
        this.endKey = endKey;
        this.limit = limit;
        this.revision = revision;
        this.sortOrder = sortOrder;
        this.sortTarget = sortTarget;
        this.serializable = serializable;
        this.keysOnly = keysOnly;
        this.countOnly = countOnly;
        this.minCreateRevision = minCreateRevision;
        this.maxCreateRevision = maxCreateRevision;
        this.minModRevision = minModRevision;
        this.maxModRevision = maxModRevision;
    }

    public long getLimit() {
        return this.limit;
    }

    public Optional<ByteSequence> getEndKey() {
        return this.endKey;
    }

    public long getRevision() {
        return this.revision;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortTarget getSortField() {
        return this.sortTarget;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public boolean isKeysOnly() {
        return this.keysOnly;
    }

    public boolean isCountOnly() {
        return this.countOnly;
    }

    public long getMinCreateRevision() {
        return this.minCreateRevision;
    }

    public long getMaxCreateRevision() {
        return this.maxCreateRevision;
    }

    public long getMinModRevision() {
        return this.minModRevision;
    }

    public long getMaxModRevision() {
        return this.maxModRevision;
    }

    public static enum SortTarget {
        KEY,
        VERSION,
        CREATE,
        MOD,
        VALUE;

    }

    public static enum SortOrder {
        NONE,
        ASCEND,
        DESCEND;

    }

    public static class Builder {
        private long limit = 0L;
        private long revision = 0L;
        private SortOrder sortOrder = SortOrder.NONE;
        private SortTarget sortTarget = SortTarget.KEY;
        private boolean serializable = false;
        private boolean keysOnly = false;
        private boolean countOnly = false;
        private Optional<ByteSequence> endKey = Optional.empty();
        private long minCreateRevision = 0L;
        private long maxCreateRevision = 0L;
        private long minModRevision = 0L;
        private long maxModRevision = 0L;

        private Builder() {
        }

        public Builder withLimit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder withRevision(long revision) {
            this.revision = revision;
            return this;
        }

        public Builder withSortOrder(SortOrder order) {
            this.sortOrder = order;
            return this;
        }

        public Builder withSortField(SortTarget field) {
            this.sortTarget = field;
            return this;
        }

        public Builder withSerializable(boolean serializable) {
            this.serializable = serializable;
            return this;
        }

        public Builder withKeysOnly(boolean keysOnly) {
            this.keysOnly = keysOnly;
            return this;
        }

        public Builder withCountOnly(boolean countOnly) {
            this.countOnly = countOnly;
            return this;
        }

        public Builder withRange(ByteSequence endKey) {
            this.endKey = Optional.ofNullable(endKey);
            return this;
        }

        public Builder withPrefix(ByteSequence prefix) {
            Preconditions.checkNotNull((Object)prefix, (Object)"prefix should not be null");
            ByteSequence prefixEnd = OptionsUtil.prefixEndOf(prefix);
            this.withRange(prefixEnd);
            return this;
        }

        public Builder withMinCreateRevision(long createRevision) {
            this.minCreateRevision = createRevision;
            return this;
        }

        public Builder withMaxCreateRevision(long createRevision) {
            this.maxCreateRevision = createRevision;
            return this;
        }

        public Builder withMinModRevision(long modRevision) {
            this.minModRevision = modRevision;
            return this;
        }

        public Builder withMaxModRevision(long modRevision) {
            this.maxModRevision = modRevision;
            return this;
        }

        public GetOption build() {
            return new GetOption(this.endKey, this.limit, this.revision, this.sortOrder, this.sortTarget, this.serializable, this.keysOnly, this.countOnly, this.minCreateRevision, this.maxCreateRevision, this.minModRevision, this.maxModRevision);
        }
    }
}

