/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.boot.autoconfigure.http;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.seata.common.rpc.http.HttpContext;
import org.apache.seata.core.rpc.netty.http.ControllerManager;
import org.apache.seata.core.rpc.netty.http.HttpInvocation;
import org.apache.seata.core.rpc.netty.http.ParamMetaData;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Component
public class RestControllerBeanPostProcessor
implements BeanPostProcessor {
    private static final List<Class<? extends Annotation>> MAPPING_CLASS = new ArrayList<Class<? extends Annotation>>();
    private static final Map<Class<? extends Annotation>, ParamMetaData.ParamConvertType> MAPPING_PARAM_TYPE = new HashMap<Class<? extends Annotation>, ParamMetaData.ParamConvertType>();
    private static final Set<Class<?>> SIMPLE_TYPE = new HashSet();
    private static final Set<Class<?>> SPECIAL_INJECTED_TYPE = new HashSet();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Method[] methods;
        if (!bean.getClass().isAnnotationPresent(RestController.class)) {
            return bean;
        }
        Class<?> httpControllerClass = bean.getClass();
        RequestMapping requestMapping = httpControllerClass.getAnnotation(RequestMapping.class);
        List<String> prePaths = requestMapping != null ? Arrays.asList(requestMapping.value()) : new ArrayList<String>();
        for (Method method : methods = httpControllerClass.getDeclaredMethods()) {
            for (Class<? extends Annotation> annotationType : MAPPING_CLASS) {
                Annotation annotation = method.getAnnotation(annotationType);
                if (annotation == null) continue;
                List<String> postPaths = RestControllerBeanPostProcessor.getAnnotationValue(annotation);
                RestControllerBeanPostProcessor.addPathMapping(bean, prePaths, method, postPaths);
            }
        }
        return bean;
    }

    private static List<String> getAnnotationValue(Annotation annotation) {
        try {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            Method valueMethod = annotationClass.getMethod("value", new Class[0]);
            valueMethod.setAccessible(true);
            return Arrays.asList((String[])valueMethod.invoke((Object)annotation, new Object[0]));
        }
        catch (Throwable e) {
            return new ArrayList<String>();
        }
    }

    private static void addPathMapping(Object httpController, List<String> prePaths, Method method, List<String> postPaths) {
        int i;
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ParamMetaData[] paramMetaDatas = new ParamMetaData[parameterTypes.length];
        Parameter[] parameters = method.getParameters();
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            ParamMetaData paramMetaData;
            Annotation matchedAnnotation = null;
            Class<? extends Annotation> parameterAnnotationType = null;
            if (parameterAnnotations[i2] != null && parameterAnnotations[i2].length > 0) {
                for (Annotation annotation : parameterAnnotations[i2]) {
                    if (!MAPPING_PARAM_TYPE.containsKey(annotation.annotationType())) continue;
                    parameterAnnotationType = annotation.annotationType();
                    matchedAnnotation = annotation;
                    break;
                }
            }
            paramMetaDatas[i2] = paramMetaData = RestControllerBeanPostProcessor.buildParamMetaData(matchedAnnotation, parameterTypes[i2], parameterAnnotationType, parameters[i2]);
        }
        int maxSize = Math.max(prePaths.size(), postPaths.size());
        for (i = prePaths.size(); i < maxSize; ++i) {
            prePaths.add("/");
        }
        for (i = postPaths.size(); i < maxSize; ++i) {
            postPaths.add("/");
        }
        for (String prePath : prePaths) {
            for (String postPath : postPaths) {
                String fullPath = (prePath + "/" + postPath).replaceAll("(/)+", "/");
                HttpInvocation httpInvocation = new HttpInvocation();
                httpInvocation.setMethod(method);
                httpInvocation.setController(httpController);
                httpInvocation.setPath(fullPath);
                httpInvocation.setParamMetaData(paramMetaDatas);
                ControllerManager.addHttpInvocation((HttpInvocation)httpInvocation);
            }
        }
    }

    private static ParamMetaData buildParamMetaData(Annotation matchedAnnotation, Class<?> parameterType, Class<? extends Annotation> parameterAnnotationType, Parameter parameter) {
        ParamMetaData paramMetaData = new ParamMetaData();
        if (parameterAnnotationType == null) {
            parameterAnnotationType = RestControllerBeanPostProcessor.resolveDefaultAnnotationType(parameterType);
            ParamMetaData.ParamConvertType paramConvertType = MAPPING_PARAM_TYPE.get(parameterAnnotationType);
            paramMetaData.setParamConvertType(paramConvertType);
            if (parameterAnnotationType == RequestParam.class) {
                paramMetaData.setParamName(parameter.getName());
                paramMetaData.setRequired(true);
                paramMetaData.setDefaultValue("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
            }
        } else {
            ParamMetaData.ParamConvertType paramConvertType = MAPPING_PARAM_TYPE.get(parameterAnnotationType);
            paramMetaData.setParamConvertType(paramConvertType);
            if (parameterAnnotationType == RequestParam.class) {
                RequestParam requestParam = (RequestParam)matchedAnnotation;
                boolean required = true;
                String defaultValue = null;
                String paramName = Optional.ofNullable(requestParam.name()).filter(name -> !name.isEmpty()).orElseGet(() -> {
                    String value = requestParam.value();
                    return !value.isEmpty() ? value : parameter.getName();
                });
                required = requestParam.required();
                defaultValue = requestParam.defaultValue();
                if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue)) {
                    required = false;
                }
                paramMetaData.setParamName(paramName);
                paramMetaData.setRequired(required);
                paramMetaData.setDefaultValue(defaultValue);
            }
        }
        return paramMetaData;
    }

    private static Class<? extends Annotation> resolveDefaultAnnotationType(Class<?> paramType) {
        if (SPECIAL_INJECTED_TYPE.stream().anyMatch(t -> t.isAssignableFrom(paramType))) {
            return null;
        }
        if (paramType.isPrimitive() || SIMPLE_TYPE.contains(paramType) || MultipartFile.class.isAssignableFrom(paramType)) {
            return RequestParam.class;
        }
        return ModelAttribute.class;
    }

    static {
        MAPPING_CLASS.add(GetMapping.class);
        MAPPING_CLASS.add(PostMapping.class);
        MAPPING_CLASS.add(RequestMapping.class);
        MAPPING_CLASS.add(PutMapping.class);
        MAPPING_CLASS.add(DeleteMapping.class);
        MAPPING_PARAM_TYPE.put(RequestParam.class, ParamMetaData.ParamConvertType.REQUEST_PARAM);
        MAPPING_PARAM_TYPE.put(RequestBody.class, ParamMetaData.ParamConvertType.REQUEST_BODY);
        MAPPING_PARAM_TYPE.put(ModelAttribute.class, ParamMetaData.ParamConvertType.MODEL_ATTRIBUTE);
        SIMPLE_TYPE.add(String.class);
        SIMPLE_TYPE.add(Integer.class);
        SIMPLE_TYPE.add(Integer.TYPE);
        SIMPLE_TYPE.add(Long.class);
        SIMPLE_TYPE.add(Long.TYPE);
        SIMPLE_TYPE.add(Boolean.class);
        SIMPLE_TYPE.add(Boolean.TYPE);
        SIMPLE_TYPE.add(Double.class);
        SIMPLE_TYPE.add(Double.TYPE);
        SIMPLE_TYPE.add(Float.class);
        SIMPLE_TYPE.add(Float.TYPE);
        SIMPLE_TYPE.add(Short.class);
        SIMPLE_TYPE.add(Short.TYPE);
        SIMPLE_TYPE.add(Byte.class);
        SIMPLE_TYPE.add(Byte.TYPE);
        SIMPLE_TYPE.add(Character.class);
        SIMPLE_TYPE.add(Character.TYPE);
        SIMPLE_TYPE.add(BigDecimal.class);
        SIMPLE_TYPE.add(BigInteger.class);
        SIMPLE_TYPE.add(Date.class);
        SIMPLE_TYPE.add(LocalDate.class);
        SIMPLE_TYPE.add(LocalDateTime.class);
        SPECIAL_INJECTED_TYPE.add(HttpContext.class);
    }
}

