/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.remoting;

import com.alipay.remoting.BizContext;
import com.alipay.remoting.rpc.protocol.SyncUserProcessor;
import com.alipay.sofa.registry.client.api.Subscriber;
import com.alipay.sofa.registry.client.log.LoggerFactory;
import com.alipay.sofa.registry.client.model.SegmentData;
import com.alipay.sofa.registry.client.provider.DefaultSubscriber;
import com.alipay.sofa.registry.client.provider.RegisterCache;
import com.alipay.sofa.registry.client.task.ObserverHandler;
import com.alipay.sofa.registry.core.model.ReceivedData;
import com.alipay.sofa.registry.core.model.Result;
import java.util.List;
import org.slf4j.Logger;

public class ReceivedDataProcessor
extends SyncUserProcessor<ReceivedData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceivedDataProcessor.class);
    private RegisterCache registerCache;
    private ObserverHandler observerHandler;

    public ReceivedDataProcessor(RegisterCache registerCache, ObserverHandler observerHandler) {
        this.registerCache = registerCache;
        this.observerHandler = observerHandler;
    }

    public Object handleRequest(BizContext bizCtx, ReceivedData request) {
        Result result = new Result();
        result.setSuccess(true);
        if (null == request || null == request.getData()) {
            return result;
        }
        try {
            List<String> registIds = request.getSubscriberRegistIds();
            SegmentData segmentData = new SegmentData();
            segmentData.setData(request.getData());
            segmentData.setVersion(request.getVersion());
            segmentData.setSegment(request.getSegment());
            for (String registId : registIds) {
                Subscriber subscriber = this.registerCache.getSubscriberByRegistId(registId);
                if (null == subscriber) continue;
                if (subscriber instanceof DefaultSubscriber) {
                    DefaultSubscriber defaultSubscriber = (DefaultSubscriber)subscriber;
                    defaultSubscriber.putReceivedData(segmentData, request.getLocalZone());
                    try {
                        this.observerHandler.notify(subscriber);
                    }
                    catch (Exception e) {
                        LOGGER.error("[received] add notify task error, dataId: {}, registId: {}", new Object[]{subscriber.getDataId(), subscriber.getRegistId(), e});
                    }
                    continue;
                }
                LOGGER.warn("[received] ignore unknown subscriber type: {}", (Object)subscriber.getClass().getName());
            }
            LOGGER.info("[received] receive subscriber data save success, dataId: {} group: {} version: {} data:{} registIds:{}", new Object[]{request.getDataId(), request.getGroup(), request.getVersion(), request.getData(), registIds});
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setMessage("");
            LOGGER.info("[received] receive subscriber data save failed, dataId: {} group: {} version: {} data:{}", new Object[]{request.getDataId(), request.getGroup(), request.getVersion(), request.getData(), e});
        }
        return result;
    }

    public String interest() {
        return ReceivedData.class.getName();
    }
}

