/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLPivot;
import com.alibaba.druid.sql.ast.SQLUnpivot;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public abstract class SQLTableSourceImpl
extends SQLObjectImpl
implements SQLTableSource {
    protected boolean needAsTokenForAlias;
    protected String alias;
    protected List<SQLHint> hints;
    protected SQLExpr flashback;
    protected long aliasHashCode64;
    protected SQLPivot pivot;
    protected SQLUnpivot unpivot;

    public SQLTableSourceImpl() {
    }

    public SQLTableSourceImpl(String alias) {
        this.alias = alias;
    }

    public boolean isNeedAsTokenForAlias() {
        return this.needAsTokenForAlias;
    }

    public void setNeedAsTokenForAlias(boolean needAsTokenForAlias) {
        this.needAsTokenForAlias = needAsTokenForAlias;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public String getAlias2() {
        if (this.alias == null || this.alias.length() == 0) {
            return this.alias;
        }
        char first = this.alias.charAt(0);
        if (first == '\"' || first == '\'') {
            char[] chars = new char[this.alias.length() - 2];
            int len = 0;
            for (int i = 1; i < this.alias.length() - 1; ++i) {
                char ch = this.alias.charAt(i);
                if (ch == '\\') {
                    ch = this.alias.charAt(++i);
                }
                chars[len++] = ch;
            }
            return new String(chars, 0, len);
        }
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
        this.aliasHashCode64 = 0L;
    }

    public int getHintsSize() {
        if (this.hints == null) {
            return 0;
        }
        return this.hints.size();
    }

    @Override
    public List<SQLHint> getHints() {
        if (this.hints == null) {
            this.hints = new ArrayList<SQLHint>(2);
        }
        return this.hints;
    }

    public void setHints(List<SQLHint> hints) {
        this.hints = hints;
    }

    @Override
    public SQLTableSource clone() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public String computeAlias() {
        return this.alias;
    }

    @Override
    public SQLExpr getFlashback() {
        return this.flashback;
    }

    @Override
    public void setFlashback(SQLExpr flashback) {
        if (flashback != null) {
            flashback.setParent(this);
        }
        this.flashback = flashback;
    }

    @Override
    public boolean containsAlias(String alias) {
        return SQLUtils.nameEquals(this.alias, alias);
    }

    @Override
    public long aliasHashCode64() {
        if (this.aliasHashCode64 == 0L && this.alias != null) {
            this.aliasHashCode64 = FnvHash.hashCode64(this.alias);
        }
        return this.aliasHashCode64;
    }

    @Override
    public SQLColumnDefinition findColumn(String columnName) {
        if (columnName == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(columnName);
        return this.findColumn(hash);
    }

    @Override
    public SQLColumnDefinition findColumn(long columnNameHash) {
        return null;
    }

    @Override
    public SQLObject resolveColumn(long columnNameHash) {
        return this.findColumn(columnNameHash);
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(String columnName) {
        if (columnName == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(columnName);
        return this.findTableSourceWithColumn(hash, columnName, 0);
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(SQLName columnName) {
        SQLExpr owner;
        if (columnName instanceof SQLIdentifierExpr) {
            return this.findTableSourceWithColumn(columnName.nameHashCode64(), columnName.getSimpleName(), 0);
        }
        if (columnName instanceof SQLPropertyExpr && (owner = ((SQLPropertyExpr)columnName).getOwner()) instanceof SQLIdentifierExpr) {
            return this.findTableSource(((SQLIdentifierExpr)owner).nameHashCode64());
        }
        return null;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(long columnNameHash) {
        return this.findTableSourceWithColumn(columnNameHash, null, 0);
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(long columnNameHash, String columnName, int option) {
        return null;
    }

    @Override
    public SQLTableSource findTableSource(String alias) {
        long hash = FnvHash.hashCode64(alias);
        return this.findTableSource(hash);
    }

    @Override
    public SQLTableSource findTableSource(long alias_hash) {
        long hash = this.aliasHashCode64();
        if (hash != 0L && hash == alias_hash) {
            return this;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLTableSourceImpl that = (SQLTableSourceImpl)o;
        if (this.aliasHashCode64() != that.aliasHashCode64()) {
            return false;
        }
        if (this.hints != null ? !this.hints.equals(that.hints) : that.hints != null) {
            return false;
        }
        return this.flashback != null ? this.flashback.equals(that.flashback) : that.flashback == null;
    }

    public int hashCode() {
        int result = this.hints != null ? this.hints.hashCode() : 0;
        result = 31 * result + (this.flashback != null ? this.flashback.hashCode() : 0);
        result = 31 * result + (int)(this.aliasHashCode64() ^ this.aliasHashCode64() >>> 32);
        return result;
    }

    @Override
    public SQLPivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(SQLPivot x) {
        if (x != null) {
            x.setParent(this);
        }
        this.pivot = x;
    }

    @Override
    public SQLUnpivot getUnpivot() {
        return this.unpivot;
    }

    @Override
    public void setUnpivot(SQLUnpivot x) {
        if (x != null) {
            x.setParent(this);
        }
        this.unpivot = x;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.flashback);
            this.acceptChild(visitor, this.pivot);
            this.acceptChild(visitor, this.unpivot);
        }
        visitor.endVisit(this);
    }
}

