/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.mock;

import com.alibaba.druid.mock.MockConnection;
import com.alibaba.druid.mock.MockResultSet;
import com.alibaba.druid.mock.MockStatementBase;
import com.alibaba.druid.util.jdbc.StatementBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class MockStatement
extends StatementBase
implements MockStatementBase,
Statement {
    public static final String ERROR_SQL = "THROW ERROR";
    protected MockConnection mockConnection;

    public MockStatement(Connection connection) {
        super(connection);
        if (connection instanceof MockConnection) {
            this.mockConnection = (MockConnection)connection;
        }
    }

    @Override
    protected void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException();
        }
        if (this.mockConnection != null) {
            this.mockConnection.checkState();
        }
    }

    @Override
    public MockConnection getConnection() {
        return this.mockConnection;
    }

    public void setFakeConnection(MockConnection fakeConnection) {
        this.mockConnection = fakeConnection;
        this.setConnection(fakeConnection);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        if (this.mockConnection != null && this.mockConnection.getDriver() != null) {
            return this.mockConnection.getDriver().executeQuery(this, sql);
        }
        ArrayList<Object[]> mockRows = new ArrayList<Object[]>();
        mockRows.add(new Object[1]);
        return new MockResultSet(this, mockRows);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        if (this.mockConnection != null) {
            this.mockConnection.handleSleep();
        }
        return 0;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        if (ERROR_SQL.equals(sql)) {
            throw new SQLException();
        }
        if (this.mockConnection != null) {
            this.mockConnection.setLastSql(sql);
            this.mockConnection.handleSleep();
        }
        return false;
    }
}

