/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import org.apache.seata.common.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtil.class);

    public static void close(AutoCloseable ... closeables) {
        if (CollectionUtils.isNotEmpty(closeables)) {
            for (AutoCloseable closeable : closeables) {
                IOUtil.close(closeable);
            }
        }
    }

    public static void close(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close resource", (Throwable)e);
            }
        }
    }
}

