/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.protobuf.convertor;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.core.protocol.AbstractResultMessage;
import org.apache.seata.core.protocol.BatchResultMessage;
import org.apache.seata.serializer.protobuf.convertor.PbConvertor;
import org.apache.seata.serializer.protobuf.generated.AbstractMessageProto;
import org.apache.seata.serializer.protobuf.generated.BatchResultMessageProto;
import org.apache.seata.serializer.protobuf.generated.MessageTypeProto;
import org.apache.seata.serializer.protobuf.manager.ProtobufConvertManager;

public class BatchResultMessageConvertor
implements PbConvertor<BatchResultMessage, BatchResultMessageProto> {
    @Override
    public BatchResultMessageProto convert2Proto(BatchResultMessage batchResultMessage) {
        short typeCode = batchResultMessage.getTypeCode();
        AbstractMessageProto abstractMessage = AbstractMessageProto.newBuilder().setMessageType(MessageTypeProto.forNumber(typeCode)).build();
        ArrayList lists = new ArrayList();
        batchResultMessage.getResultMessages().forEach(msg -> {
            PbConvertor pbConvertor = ProtobufConvertManager.getInstance().fetchConvertor(msg.getClass().getName());
            lists.add(Any.pack((Message)((Message)pbConvertor.convert2Proto(msg))));
        });
        return BatchResultMessageProto.newBuilder().setAbstractMessage(abstractMessage).addAllResultMessages(lists).addAllMsgIds(batchResultMessage.getMsgIds()).build();
    }

    @Override
    public BatchResultMessage convert2Model(BatchResultMessageProto batchResultMessageProto) {
        BatchResultMessage result = new BatchResultMessage();
        List<Any> anys = batchResultMessageProto.getResultMessagesList();
        anys.forEach(any -> {
            Class clazz = ProtobufConvertManager.getInstance().fetchProtoClass(BatchResultMessageConvertor.getTypeNameFromTypeUrl(any.getTypeUrl()));
            if (any.is(clazz)) {
                try {
                    Message ob = any.unpack(clazz);
                    PbConvertor pbConvertor = ProtobufConvertManager.getInstance().fetchReversedConvertor(clazz.getName());
                    Object model = pbConvertor.convert2Model(ob);
                    result.getResultMessages().add((AbstractResultMessage)model);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new ShouldNeverHappenException((Throwable)e);
                }
            }
        });
        result.setMsgIds(batchResultMessageProto.getMsgIdsList());
        return result;
    }

    private static String getTypeNameFromTypeUrl(String typeUrl) {
        int pos = typeUrl.lastIndexOf(47);
        return pos == -1 ? "" : typeUrl.substring(pos + 1);
    }
}

