/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.plugin.NullClassLoader;
import org.apache.skywalking.apm.agent.core.plugin.WitnessMethod;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.method.MethodList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.pool.TypePool;

public enum WitnessFinder {
    INSTANCE;

    private final Map<ClassLoader, TypePool> poolMap = new HashMap<ClassLoader, TypePool>();

    public boolean exist(String witnessClass, ClassLoader classLoader) {
        return this.getResolution(witnessClass, classLoader).isResolved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypePool.Resolution getResolution(String witnessClass, ClassLoader classLoader) {
        ClassLoader mappingKey;
        ClassLoader classLoader2 = mappingKey = classLoader == null ? NullClassLoader.INSTANCE : classLoader;
        if (!this.poolMap.containsKey(mappingKey)) {
            Map<ClassLoader, TypePool> map = this.poolMap;
            synchronized (map) {
                if (!this.poolMap.containsKey(mappingKey)) {
                    TypePool classTypePool = classLoader == null ? TypePool.Default.ofBootLoader() : TypePool.Default.of(classLoader);
                    this.poolMap.put(mappingKey, classTypePool);
                }
            }
        }
        TypePool typePool = this.poolMap.get(mappingKey);
        return typePool.describe(witnessClass);
    }

    public boolean exist(WitnessMethod witnessMethod, ClassLoader classLoader) {
        TypePool.Resolution resolution = this.getResolution(witnessMethod.getDeclaringClassName(), classLoader);
        if (!resolution.isResolved()) {
            return false;
        }
        return !((MethodList)resolution.resolve().getDeclaredMethods().filter(witnessMethod.getElementMatcher())).isEmpty();
    }
}

