/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.conf.dynamic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.commands.CommandService;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.dynamic.AgentConfigChangeWatcher;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelListener;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelStatus;
import org.apache.skywalking.apm.dependencies.com.google.common.collect.Lists;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.v3.ConfigurationDiscoveryServiceGrpc;
import org.apache.skywalking.apm.network.language.agent.v3.ConfigurationSyncRequest;
import org.apache.skywalking.apm.network.trace.component.command.ConfigurationDiscoveryCommand;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;
import org.apache.skywalking.apm.util.StringUtil;

@DefaultImplementor
public class ConfigurationDiscoveryService
implements BootService,
GRPCChannelListener {
    private String uuid;
    private final Register register = new Register();
    private volatile int lastRegisterWatcherSize;
    private volatile ScheduledFuture<?> getDynamicConfigurationFuture;
    private volatile GRPCChannelStatus status = GRPCChannelStatus.DISCONNECT;
    private volatile ConfigurationDiscoveryServiceGrpc.ConfigurationDiscoveryServiceBlockingStub configurationDiscoveryServiceBlockingStub;
    private static final ILog LOGGER = LogManager.getLogger(ConfigurationDiscoveryService.class);

    @Override
    public void statusChanged(GRPCChannelStatus status) {
        if (GRPCChannelStatus.CONNECTED.equals((Object)status)) {
            Channel channel = ServiceManager.INSTANCE.findService(GRPCChannelManager.class).getChannel();
            this.configurationDiscoveryServiceBlockingStub = ConfigurationDiscoveryServiceGrpc.newBlockingStub(channel);
        } else {
            this.configurationDiscoveryServiceBlockingStub = null;
        }
        this.status = status;
    }

    @Override
    public void prepare() throws Throwable {
        ServiceManager.INSTANCE.findService(GRPCChannelManager.class).addChannelListener(this);
    }

    @Override
    public void boot() throws Throwable {
        this.getDynamicConfigurationFuture = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("ConfigurationDiscoveryService")).scheduleAtFixedRate(new RunnableWithExceptionProtection(this::getAgentDynamicConfig, t -> LOGGER.error("Sync config from OAP error.", t)), Config.Collector.GET_AGENT_DYNAMIC_CONFIG_INTERVAL, Config.Collector.GET_AGENT_DYNAMIC_CONFIG_INTERVAL, TimeUnit.SECONDS);
    }

    @Override
    public void onComplete() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
        if (this.getDynamicConfigurationFuture != null) {
            this.getDynamicConfigurationFuture.cancel(true);
        }
    }

    public void registerAgentConfigChangeWatcher(AgentConfigChangeWatcher watcher) {
        WatcherHolder holder = new WatcherHolder(watcher);
        if (this.register.containsKey(holder.getKey())) {
            throw new IllegalStateException("Duplicate register, watcher=" + watcher);
        }
        this.register.put(holder.getKey(), holder);
    }

    public void handleConfigurationDiscoveryCommand(ConfigurationDiscoveryCommand configurationDiscoveryCommand) {
        String responseUuid = configurationDiscoveryCommand.getUuid();
        if (responseUuid != null && Objects.equals(this.uuid, responseUuid)) {
            return;
        }
        List<KeyStringValuePair> config = this.readConfig(configurationDiscoveryCommand);
        config.forEach(property -> {
            String propertyKey = property.getKey();
            WatcherHolder holder = this.register.get(propertyKey);
            if (holder != null) {
                AgentConfigChangeWatcher watcher = holder.getWatcher();
                String newPropertyValue = property.getValue();
                if (StringUtil.isBlank(newPropertyValue)) {
                    if (watcher.value() != null) {
                        watcher.notify(new AgentConfigChangeWatcher.ConfigChangeEvent(null, AgentConfigChangeWatcher.EventType.DELETE));
                    }
                } else if (!newPropertyValue.equals(watcher.value())) {
                    watcher.notify(new AgentConfigChangeWatcher.ConfigChangeEvent(newPropertyValue, AgentConfigChangeWatcher.EventType.MODIFY));
                }
            } else {
                LOGGER.warn("Config {} from OAP, doesn't match any watcher, ignore.", propertyKey);
            }
        });
        this.uuid = responseUuid;
        LOGGER.trace("Current configurations after the sync, configurations:{}", this.register.toString());
    }

    private List<KeyStringValuePair> readConfig(ConfigurationDiscoveryCommand configurationDiscoveryCommand) {
        Map commandConfigs = configurationDiscoveryCommand.getConfig().stream().collect(Collectors.toMap(KeyStringValuePair::getKey, Function.identity()));
        ArrayList<KeyStringValuePair> configList = Lists.newArrayList();
        for (String name : this.register.keys()) {
            KeyStringValuePair command = commandConfigs.getOrDefault(name, KeyStringValuePair.newBuilder().setKey(name).build());
            configList.add(command);
        }
        return configList;
    }

    private void getAgentDynamicConfig() {
        LOGGER.debug("ConfigurationDiscoveryService running, status:{}.", new Object[]{this.status});
        if (GRPCChannelStatus.CONNECTED.equals((Object)this.status)) {
            try {
                ConfigurationSyncRequest.Builder builder = ConfigurationSyncRequest.newBuilder();
                builder.setService(Config.Agent.SERVICE_NAME);
                int size = this.register.keys().size();
                if (this.lastRegisterWatcherSize != size) {
                    this.uuid = null;
                    this.lastRegisterWatcherSize = size;
                }
                if (null != this.uuid) {
                    builder.setUuid(this.uuid);
                }
                if (this.configurationDiscoveryServiceBlockingStub != null) {
                    Commands commands = ((ConfigurationDiscoveryServiceGrpc.ConfigurationDiscoveryServiceBlockingStub)this.configurationDiscoveryServiceBlockingStub.withDeadlineAfter(Config.Collector.GRPC_UPSTREAM_TIMEOUT, TimeUnit.SECONDS)).fetchConfigurations(builder.build());
                    ServiceManager.INSTANCE.findService(CommandService.class).receiveCommand(commands);
                }
            }
            catch (Throwable t) {
                LOGGER.error(t, "ConfigurationDiscoveryService execute fail.", new Object[0]);
                ServiceManager.INSTANCE.findService(GRPCChannelManager.class).reportError(t);
            }
        }
    }

    private static class WatcherHolder {
        private final AgentConfigChangeWatcher watcher;
        private final String key;

        public WatcherHolder(AgentConfigChangeWatcher watcher) {
            this.watcher = watcher;
            this.key = watcher.getPropertyKey();
        }

        @Generated
        public AgentConfigChangeWatcher getWatcher() {
            return this.watcher;
        }

        @Generated
        public String getKey() {
            return this.key;
        }
    }

    public static class Register {
        private final Map<String, WatcherHolder> register = new HashMap<String, WatcherHolder>();

        private boolean containsKey(String key) {
            return this.register.containsKey(key);
        }

        private void put(String key, WatcherHolder holder) {
            this.register.put(key, holder);
        }

        public WatcherHolder get(String name) {
            return this.register.get(name);
        }

        public Set<String> keys() {
            return this.register.keySet();
        }

        public String toString() {
            ArrayList registerTableDescription = new ArrayList(this.register.size());
            this.register.forEach((key, holder) -> {
                AgentConfigChangeWatcher watcher = holder.getWatcher();
                registerTableDescription.add("key:" + key + "value(current):" + watcher.value());
            });
            return registerTableDescription.stream().collect(Collectors.joining(",", "[", "]"));
        }
    }
}

