/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.infra.rpc;

import com.xiaomi.youpin.infra.rpc.errors.BizError;
import com.xiaomi.youpin.infra.rpc.errors.ErrorCode;
import com.xiaomi.youpin.infra.rpc.errors.GeneralCodes;
import java.io.Serializable;
import java.util.Map;

public class Result<T>
implements Serializable {
    private int code;
    private String message;
    private T data;
    private String traceId;
    private Map<String, String> attachments;
    private static String SUCCESS_MESSAGE = "ok";

    Result(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public Result() {
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>(GeneralCodes.OK.getCode(), SUCCESS_MESSAGE, data);
    }

    public static <T> Result<T> fail(ErrorCode code, String message) {
        return new Result<Object>(code.getCode(), message, null);
    }

    public static <T> Result<T> fromException(Throwable e) {
        if (e instanceof BizError) {
            return new Result<Object>(((BizError)e).getCode(), ((BizError)e).getMessage(), null);
        }
        return Result.fail(GeneralCodes.InternalError, "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    public static <T> Result<T> fromException(Throwable e, String message) {
        if (e instanceof BizError) {
            return new Result<Object>(((BizError)e).getCode(), message, null);
        }
        return Result.fail(GeneralCodes.InternalError, message);
    }

    public String toString() {
        return String.format("Result{code=%d, message=%s, data=%s}", this.code, this.message, this.data);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Map<String, String> attachments) {
        this.attachments = attachments;
    }
}

