/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.listener;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.InvokerListener;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

public class ListenerInvokerWrapper<T>
implements Invoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(ListenerInvokerWrapper.class);
    private final Invoker<T> invoker;
    private final List<InvokerListener> listeners;

    public ListenerInvokerWrapper(Invoker<T> invoker, List<InvokerListener> listeners) {
        if (invoker == null) {
            throw new IllegalArgumentException("invoker == null");
        }
        this.invoker = invoker;
        this.listeners = listeners;
        if (CollectionUtils.isNotEmpty(listeners)) {
            for (InvokerListener listener : listeners) {
                if (listener == null) continue;
                try {
                    listener.referred(invoker);
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
            }
        }
    }

    @Override
    public Class<T> getInterface() {
        return this.invoker.getInterface();
    }

    @Override
    public URL getUrl() {
        return this.invoker.getUrl();
    }

    @Override
    public boolean isAvailable() {
        return this.invoker.isAvailable();
    }

    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        return this.invoker.invoke(invocation);
    }

    public String toString() {
        return this.getInterface() + " -> " + (this.getUrl() == null ? " " : this.getUrl().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            this.invoker.destroy();
        }
        finally {
            if (CollectionUtils.isNotEmpty(this.listeners)) {
                for (InvokerListener listener : this.listeners) {
                    if (listener == null) continue;
                    try {
                        listener.destroyed(this.invoker);
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                    }
                }
            }
        }
    }
}

