/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.gem.MapMappingGem;
import org.mapstruct.ap.internal.gem.NullValueMappingStrategyGem;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.source.DelegatingOptions;
import org.mapstruct.ap.internal.model.source.MapperOptions;
import org.mapstruct.ap.internal.model.source.MappingControl;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class MapMappingOptions
extends DelegatingOptions {
    private final SelectionParameters keySelectionParameters;
    private final SelectionParameters valueSelectionParameters;
    private final FormattingParameters keyFormattingParameters;
    private final FormattingParameters valueFormattingParameters;
    private final MapMappingGem mapMapping;

    public static MapMappingOptions fromGem(MapMappingGem mapMapping, MapperOptions mapperOptions, ExecutableElement method, FormattingMessager messager, Types typeUtils) {
        if (mapMapping == null || !MapMappingOptions.isConsistent(mapMapping, method, messager)) {
            MapMappingOptions options = new MapMappingOptions(null, null, null, null, null, mapperOptions);
            return options;
        }
        SelectionParameters keySelection = new SelectionParameters(mapMapping.keyQualifiedBy().get(), mapMapping.keyQualifiedByName().get(), mapMapping.keyTargetType().getValue(), typeUtils);
        SelectionParameters valueSelection = new SelectionParameters(mapMapping.valueQualifiedBy().get(), mapMapping.valueQualifiedByName().get(), mapMapping.valueTargetType().getValue(), typeUtils);
        FormattingParameters keyFormatting = new FormattingParameters(mapMapping.keyDateFormat().get(), mapMapping.keyNumberFormat().get(), mapMapping.mirror(), mapMapping.keyDateFormat().getAnnotationValue(), method);
        FormattingParameters valueFormatting = new FormattingParameters(mapMapping.valueDateFormat().get(), mapMapping.valueNumberFormat().get(), mapMapping.mirror(), mapMapping.valueDateFormat().getAnnotationValue(), method);
        MapMappingOptions options = new MapMappingOptions(keyFormatting, keySelection, valueFormatting, valueSelection, mapMapping, mapperOptions);
        return options;
    }

    private static boolean isConsistent(MapMappingGem gem, ExecutableElement method, FormattingMessager messager) {
        if (!(gem.keyDateFormat().hasValue() || gem.keyNumberFormat().hasValue() || gem.keyQualifiedBy().hasValue() || gem.keyQualifiedByName().hasValue() || gem.valueDateFormat().hasValue() || gem.valueNumberFormat().hasValue() || gem.valueQualifiedBy().hasValue() || gem.valueQualifiedByName().hasValue() || gem.keyTargetType().hasValue() || gem.valueTargetType().hasValue() || gem.nullValueMappingStrategy().hasValue())) {
            messager.printMessage((Element)method, Message.MAPMAPPING_NO_ELEMENTS, new Object[0]);
            return false;
        }
        return true;
    }

    private MapMappingOptions(FormattingParameters keyFormatting, SelectionParameters keySelectionParameters, FormattingParameters valueFormatting, SelectionParameters valueSelectionParameters, MapMappingGem mapMapping, DelegatingOptions next) {
        super(next);
        this.keyFormattingParameters = keyFormatting;
        this.keySelectionParameters = keySelectionParameters;
        this.valueFormattingParameters = valueFormatting;
        this.valueSelectionParameters = valueSelectionParameters;
        this.mapMapping = mapMapping;
    }

    public FormattingParameters getKeyFormattingParameters() {
        return this.keyFormattingParameters;
    }

    public SelectionParameters getKeySelectionParameters() {
        return this.keySelectionParameters;
    }

    public FormattingParameters getValueFormattingParameters() {
        return this.valueFormattingParameters;
    }

    public SelectionParameters getValueSelectionParameters() {
        return this.valueSelectionParameters;
    }

    public AnnotationMirror getMirror() {
        return Optional.ofNullable(this.mapMapping).map(MapMappingGem::mirror).orElse(null);
    }

    @Override
    public NullValueMappingStrategyGem getNullValueMappingStrategy() {
        return Optional.ofNullable(this.mapMapping).map(MapMappingGem::nullValueMappingStrategy).filter(GemValue::hasValue).map(GemValue::getValue).map(NullValueMappingStrategyGem::valueOf).orElse(this.next().getNullValueMappingStrategy());
    }

    public MappingControl getKeyMappingControl(Elements elementUtils) {
        return Optional.ofNullable(this.mapMapping).map(MapMappingGem::keyMappingControl).filter(GemValue::hasValue).map(GemValue::getValue).map(mc -> MappingControl.fromTypeMirror(mc, elementUtils)).orElse(this.next().getMappingControl(elementUtils));
    }

    public MappingControl getValueMappingControl(Elements elementUtils) {
        return Optional.ofNullable(this.mapMapping).map(MapMappingGem::valueMappingControl).filter(GemValue::hasValue).map(GemValue::getValue).map(mc -> MappingControl.fromTypeMirror(mc, elementUtils)).orElse(this.next().getMappingControl(elementUtils));
    }

    @Override
    public boolean hasAnnotation() {
        return this.mapMapping != null;
    }
}

