/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.es;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.trace.etl.domain.DriverDomain;
import org.apache.ozhera.trace.etl.domain.ErrorTraceMessage;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerAttribute;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerESDomain;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerLogs;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerProcess;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerReferences;
import org.apache.ozhera.trace.etl.extension.es.EsTraceUtil;
import org.apache.ozhera.trace.etl.util.ExecutorUtil;
import org.apache.ozhera.tspandata.TAttributeKey;
import org.apache.ozhera.tspandata.TAttributes;
import org.apache.ozhera.tspandata.TEvent;
import org.apache.ozhera.tspandata.TLink;
import org.apache.ozhera.tspandata.TResource;
import org.apache.ozhera.tspandata.TSpanContext;
import org.apache.ozhera.tspandata.TSpanData;
import org.apache.ozhera.tspandata.TValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class WriteEsService {
    private static final Logger log = LoggerFactory.getLogger(WriteEsService.class);
    @Value(value="${es.trace.index.prefix}")
    private String indexPrefix;
    @Value(value="${es.trace.index.service.prefix}")
    private String servicePrefix;
    @Value(value="${es.trace.index.driver.prefix}")
    private String driverIndexPrefix;
    @Value(value="${es.error.index}")
    private String errorIndexPrefix;
    @Autowired
    private EsTraceUtil esTraceUtil;
    private Cache<String, String> localCache = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite(86400L, TimeUnit.SECONDS).build();

    public void insertJaegerService(String date, String serviceName, String oprationName) {
        String key = serviceName + ":" + oprationName;
        if (this.localCache.asMap().containsKey(key)) {
            return;
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("serviceName", serviceName);
        map1.put("operationName", oprationName);
        this.esTraceUtil.insertBulk(this.servicePrefix + date, map1);
        this.localCache.put((Object)key, (Object)"1");
    }

    public void submitErrorEsTrace(ErrorTraceMessage errorTraceMessage) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("domain", errorTraceMessage.getDomain());
        map.put("type", errorTraceMessage.getType());
        map.put("host", errorTraceMessage.getHost());
        map.put("url", errorTraceMessage.getUrl());
        map.put("dataSource", errorTraceMessage.getDataSource());
        map.put("serviceName", errorTraceMessage.getServiceName());
        map.put("traceId", errorTraceMessage.getTraceId());
        map.put("timestamp", errorTraceMessage.getTimestamp());
        map.put("duration", errorTraceMessage.getDuration());
        map.put("errorType", errorTraceMessage.getErrorType());
        map.put("errorCode", errorTraceMessage.getErrorCode());
        map.put("serverEnv", errorTraceMessage.getServerEnv());
        ExecutorUtil.submit(() -> {
            String format1 = DateTimeFormatter.ofPattern("yyyy.MM.dd").format(LocalDate.now());
            this.esTraceUtil.insertErrorBulk(this.errorIndexPrefix + format1, map);
        });
    }

    public String buildJaegerES(TSpanData tSpanData) {
        JaegerESDomain jaegerESDomain = new JaegerESDomain();
        jaegerESDomain.setTraceID(tSpanData.getTraceId());
        jaegerESDomain.setSpanID(tSpanData.getSpanId());
        jaegerESDomain.setOperationName(tSpanData.getName());
        long startTime = tSpanData.getStartEpochNanos();
        jaegerESDomain.setStartTime(startTime / 1000L);
        jaegerESDomain.setStartTimeMillis(startTime / 1000000L);
        long duration = tSpanData.getEndEpochNanos() - tSpanData.getStartEpochNanos();
        jaegerESDomain.setDuration(duration / 1000L);
        jaegerESDomain.setReferences(this.buildReferences(tSpanData.getParentSpanContext(), tSpanData.getLinks()));
        jaegerESDomain.setTags(this.buildAttributes(tSpanData.getAttributes()));
        jaegerESDomain.setLogs(this.buildLogs(tSpanData.getEvents()));
        jaegerESDomain.setProcess(this.buildProcess(tSpanData.getExtra().getServiceName(), tSpanData.getResouce()));
        return JSONObject.toJSONString((Object)jaegerESDomain, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    private List<JaegerReferences> buildReferences(TSpanContext parentSpanContext, List<TLink> links) {
        ArrayList<JaegerReferences> list = new ArrayList<JaegerReferences>();
        if (parentSpanContext != null) {
            JaegerReferences jaegerReferences = new JaegerReferences();
            jaegerReferences.setTraceID(parentSpanContext.getTraceId());
            jaegerReferences.setSpanID(parentSpanContext.getSpanId());
            jaegerReferences.setRefType("CHILD_OF");
            list.add(jaegerReferences);
        }
        return list;
    }

    private List<JaegerLogs> buildLogs(List<TEvent> events) {
        ArrayList<JaegerLogs> list = new ArrayList<JaegerLogs>();
        if (events != null && events.size() > 0) {
            for (TEvent tEvent : events) {
                JaegerLogs log = new JaegerLogs();
                log.setTimestamp(tEvent.getEpochNanos());
                log.setFields(this.buildAttributes(tEvent.getAttributes()));
                list.add(log);
            }
        }
        return list;
    }

    private List<JaegerAttribute> buildAttributes(TAttributes attributes) {
        ArrayList<JaegerAttribute> list = new ArrayList<JaegerAttribute>();
        if (attributes != null && attributes.getKeys() != null && attributes.getKeys().size() > 0) {
            List keys = attributes.getKeys();
            List values = attributes.getValues();
            for (int i = 0; i < keys.size(); ++i) {
                JaegerAttribute attr = new JaegerAttribute();
                TAttributeKey tAttributeKey = (TAttributeKey)keys.get(i);
                attr.setKey(tAttributeKey.getValue());
                switch (tAttributeKey.getType()) {
                    case STRING: {
                        attr.setType("string");
                        attr.setValue(this.decodeLineBreak(((TValue)values.get(i)).getStringValue()));
                        break;
                    }
                    case LONG: {
                        attr.setType("int64");
                        attr.setValue(String.valueOf(((TValue)values.get(i)).getLongValue()));
                        break;
                    }
                    case BOOLEAN: {
                        attr.setType("bool");
                        attr.setValue(String.valueOf(((TValue)values.get(i)).isBoolValue()));
                        break;
                    }
                    case DOUBLE: {
                        attr.setType("float64");
                        attr.setValue(String.valueOf(((TValue)values.get(i)).getDoubleValue()));
                    }
                }
                list.add(attr);
            }
        }
        return list;
    }

    private JaegerProcess buildProcess(String serviceName, TResource resource) {
        JaegerProcess jaegerProcess = new JaegerProcess();
        jaegerProcess.setServiceName(serviceName);
        if (resource != null) {
            jaegerProcess.setTags(this.buildAttributes(resource.getAttributes()));
        }
        return jaegerProcess;
    }

    private String decodeLineBreak(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value.replaceAll("##r'", "\\\\\"").replaceAll("##n", "\\\\n").replaceAll("##r", "\\\\r").replaceAll("##t", "\\\\t").replaceAll("##tat", "\\\\tat").replaceAll("##'", "\\\\\"");
        }
        return value;
    }

    public void insertDriver(DriverDomain driverDomain) {
        String format = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        String replace = format.replace("-", ".");
        String index = this.driverIndexPrefix + replace;
        try {
            JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)driverDomain);
            this.esTraceUtil.insertBulk(index, (Map)jsonObject);
        }
        catch (Exception e) {
            log.error("db/redis es data exception:", (Throwable)e);
        }
    }

    public void insertJaegerSpan(TSpanData tSpanData, String serviceName, String spanName) {
        SimpleDateFormat date = new SimpleDateFormat("yyyy.MM.dd");
        String format = date.format(new Date());
        this.insertJaegerService(format, serviceName, spanName);
        String jaegerESJson = this.buildJaegerES(tSpanData);
        JSONObject jsonObject = JSONObject.parseObject((String)jaegerESJson);
        this.esTraceUtil.insertBulk(this.indexPrefix + format, (Map)jsonObject);
    }
}

