/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.all.client;

import io.prometheus.client.Collector;
import io.prometheus.client.Gauge;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.ozhera.prometheus.all.client.Prometheus;
import org.apache.ozhera.prometheus.all.client.XmGauge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusGauge
implements XmGauge {
    private static final Logger log = LoggerFactory.getLogger(PrometheusGauge.class);
    public Gauge myGauge;
    public String[] labelNames;
    public String[] labelValues;

    public PrometheusGauge() {
    }

    @Override
    public void set(double delta, String ... labelValues) {
        try {
            ArrayList<String> mylist = new ArrayList<String>(Arrays.asList(labelValues));
            mylist.add(Prometheus.constLabels.get("service"));
            String[] finalValue = mylist.toArray(new String[mylist.size()]);
            ((Gauge.Child)this.myGauge.labels(finalValue)).set(delta);
        }
        catch (Throwable throwable) {
            log.warn(throwable.getMessage());
        }
    }

    public PrometheusGauge(Gauge cb, String[] lns, String[] lvs) {
        this.myGauge = cb;
        this.labelNames = lns;
        this.labelValues = lvs;
    }

    @Override
    public XmGauge with(String ... labelValue) {
        try {
            if (this.labelNames.length != labelValue.length) {
                log.warn("Incorrect numbers of labels : " + ((Collector.MetricFamilySamples)this.myGauge.describe().get((int)0)).name);
                return new PrometheusGauge();
            }
            return this;
        }
        catch (Throwable throwable) {
            log.warn(throwable.getMessage());
            return null;
        }
    }

    @Override
    public void add(double delta, String ... labelValue) {
        ArrayList<String> mylist = new ArrayList<String>(Arrays.asList(this.labelValues));
        mylist.add(Prometheus.constLabels.get("service"));
        String[] finalValue = mylist.toArray(new String[mylist.size()]);
        try {
            ((Gauge.Child)this.myGauge.labels(finalValue)).inc(delta);
        }
        catch (Throwable throwable) {
            log.warn(throwable.getMessage());
        }
    }
}

