/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.init_sql;

import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.ozhera.log.api.enums.MachineRegionEnum;
import org.apache.ozhera.log.api.enums.MiddlewareEnum;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.dao.MilogMiddlewareConfigDao;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.service.BaseService;

@Service
public class NcosConfigSqlService
extends BaseService {
    private static final String DEFAULT_NCOS_ALIAS = "system nacos";
    @Resource
    private MilogMiddlewareConfigDao milogMiddlewareConfigDao;
    @Value(value="$defaultNacosAddres")
    private String defaultNacosAddress;

    public void init() {
        String defaultRegionCode = MachineRegionEnum.CN_MACHINE.getEn();
        MilogMiddlewareConfig middlewareConfig = this.milogMiddlewareConfigDao.queryCurrentEnvNacos(defaultRegionCode);
        if (null == middlewareConfig) {
            this.addNcosConfig(defaultRegionCode);
            return;
        }
        if (Objects.equals(middlewareConfig.getNameServer(), this.defaultNacosAddress)) {
            this.updateNcosAddress(middlewareConfig);
        }
    }

    private void addNcosConfig(String defaultRegionCode) {
        MilogMiddlewareConfig middlewareConfig = new MilogMiddlewareConfig();
        middlewareConfig.setType(MiddlewareEnum.NCOS.getCode());
        middlewareConfig.setRegionEn(defaultRegionCode);
        middlewareConfig.setAlias(DEFAULT_NCOS_ALIAS);
        middlewareConfig.setNameServer(this.defaultNacosAddress);
        middlewareConfig.setIsDefault((int)Constant.YES);
        this.wrapBaseCommon(middlewareConfig, OperateEnum.ADD_OPERATE, "system");
        this.milogMiddlewareConfigDao.addMiddlewareConfig(middlewareConfig);
    }

    private void updateNcosAddress(MilogMiddlewareConfig middlewareConfig) {
        middlewareConfig.setNameServer(this.defaultNacosAddress);
        this.wrapBaseCommon(middlewareConfig, OperateEnum.UPDATE_OPERATE, "system");
        this.milogMiddlewareConfigDao.updateMiddlewareConfig(middlewareConfig);
    }
}

