/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.model.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PageInfo<T>
implements Serializable {
    private Integer page;
    private Integer pageSize;
    private Integer total;
    private Integer totalPageCount;
    private List<T> list;

    public static PageInfo emptyPageInfo() {
        return new PageInfo(0, 0, 0, Collections.emptyList());
    }

    public PageInfo(int page, int pageSize, int total, List<T> list) {
        this.page = page;
        this.pageSize = pageSize;
        this.total = total;
        this.initPage(page, pageSize, total, list, true);
    }

    public PageInfo(int page, int pageSize, int total, List<T> list, boolean hasPaged) {
        this.page = page;
        this.pageSize = pageSize;
        this.total = total;
        this.initPage(page, pageSize, total, list, hasPaged);
    }

    private void initPage(int pageIndex, int pageSize, int totalItemCount, List<T> data, boolean hasPaged) {
        if (totalItemCount > 0 && pageSize > 0) {
            this.totalPageCount = totalItemCount / pageSize + 1;
        }
        if (null == data) {
            this.list = new ArrayList<T>();
        } else if (data.isEmpty() || hasPaged) {
            this.list = data;
        } else if (pageIndex == this.totalPageCount) {
            this.list = data.subList((pageIndex - 1) * pageSize, data.size());
        } else if (pageIndex < this.totalPageCount) {
            this.list = data.subList((pageIndex - 1) * pageSize, pageIndex * pageSize);
        } else {
            throw new IndexOutOfBoundsException("The current number of pages exceeds the total number of pages");
        }
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getTotal() {
        return this.total;
    }

    public Integer getTotalPageCount() {
        return this.totalPageCount;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public void setTotalPageCount(Integer totalPageCount) {
        this.totalPageCount = totalPageCount;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageInfo)) {
            return false;
        }
        PageInfo other = (PageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$total = this.getTotal();
        Integer other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Integer this$totalPageCount = this.getTotalPageCount();
        Integer other$totalPageCount = other.getTotalPageCount();
        if (this$totalPageCount == null ? other$totalPageCount != null : !((Object)this$totalPageCount).equals(other$totalPageCount)) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Integer $totalPageCount = this.getTotalPageCount();
        result = result * 59 + ($totalPageCount == null ? 43 : ((Object)$totalPageCount).hashCode());
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "PageInfo(page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ", totalPageCount=" + this.getTotalPageCount() + ", list=" + String.valueOf(this.getList()) + ")";
    }

    public PageInfo() {
    }
}

