/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.controller;

import com.xiaomi.youpin.docean.anno.Controller;
import com.xiaomi.youpin.docean.anno.RequestMapping;
import com.xiaomi.youpin.docean.anno.RequestParam;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.model.StatisticsQuery;
import org.apache.ozhera.log.manager.model.dto.EsStatisticResult;
import org.apache.ozhera.log.manager.model.dto.EsStatisticsKeyWord;
import org.apache.ozhera.log.manager.model.vo.LogQuery;
import org.apache.ozhera.log.manager.service.StatisticsService;
import org.apache.ozhera.log.manager.service.impl.EsDataServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
public class MilogStatisticController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MilogStatisticController.class);
    @Resource
    private StatisticsService statisticsService;
    @Resource
    private EsDataServiceImpl esDataService;

    @RequestMapping(path="/milog/statistic/es")
    public Result<EsStatisticResult> statisticEs(@RequestParam(value="param") LogQuery param) throws Exception {
        return this.esDataService.EsStatistic(param);
    }

    @RequestMapping(path="/log/queryTailStatisticsByHour")
    public Result<Map<String, Long>> queryTailStatisticsByHour(StatisticsQuery statisticsQuery) throws IOException {
        return this.statisticsService.queryTailStatisticsByHour(statisticsQuery);
    }

    @RequestMapping(path="/log/queryStoreTopByDay")
    public Result<Map<String, Long>> queryStoreTopTailStatisticsByDay(StatisticsQuery statisticsQuery) throws IOException {
        return this.statisticsService.queryStoreTopTailStatisticsByDay(statisticsQuery);
    }

    @RequestMapping(path="/log/querySpaceTopStore")
    public Result<Map<String, Long>> querySpaceTopStore(StatisticsQuery statisticsQuery) throws IOException {
        return this.statisticsService.querySpaceTopStoreByDay(statisticsQuery);
    }

    @RequestMapping(path="/log/store/index/field/ration")
    public Result<List<EsStatisticsKeyWord>> queryEsStatisticsRation(LogQuery param) {
        return this.statisticsService.queryEsStatisticsRation(param);
    }
}

