/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.common;

import org.apache.ozhera.log.manager.common.ErrorCode;
import org.apache.ozhera.log.manager.common.ExceptionCode;

public class Result<T> {
    private int code;
    private String message;
    private T data;

    public Result() {
    }

    public Result(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public Result(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> Result<T> fail(ErrorCode error) {
        return new Result<T>(error.getCode(), error.getMessage());
    }

    public static <T> Result<T> fail(ExceptionCode ex) {
        return new Result<T>(ex.getCode(), ex.getMessage());
    }

    public static <T> Result<T> success(T t) {
        return new Result<T>(ErrorCode.success.getCode(), ErrorCode.success.getMessage(), t);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "Result{code=" + this.code + ", message='" + this.message + "', data=" + String.valueOf(this.data) + "}";
    }
}

