/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import com.hp.hpl.sparta.xpath.AllElementTest;
import com.hp.hpl.sparta.xpath.AttrTest;
import com.hp.hpl.sparta.xpath.BooleanExpr;
import com.hp.hpl.sparta.xpath.ElementTest;
import com.hp.hpl.sparta.xpath.ExprFactory;
import com.hp.hpl.sparta.xpath.NodeTest;
import com.hp.hpl.sparta.xpath.ParentNodeTest;
import com.hp.hpl.sparta.xpath.SimpleStreamTokenizer;
import com.hp.hpl.sparta.xpath.TextTest;
import com.hp.hpl.sparta.xpath.ThisNodeTest;
import com.hp.hpl.sparta.xpath.TrueExpr;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.IOException;

public class Step {
    public static Step DOT = new Step(ThisNodeTest.INSTANCE, TrueExpr.INSTANCE);
    private final NodeTest nodeTest_;
    private final BooleanExpr predicate_;
    private final boolean multiLevel_;

    Step(NodeTest nodeTest, BooleanExpr predicate) {
        this.nodeTest_ = nodeTest;
        this.predicate_ = predicate;
        this.multiLevel_ = false;
    }

    Step(XPath xpath, boolean multiLevel, SimpleStreamTokenizer toks) throws XPathException, IOException {
        this.multiLevel_ = multiLevel;
        switch (toks.ttype) {
            case 46: {
                if (toks.nextToken() == 46) {
                    this.nodeTest_ = ParentNodeTest.INSTANCE;
                    break;
                }
                toks.pushBack();
                this.nodeTest_ = ThisNodeTest.INSTANCE;
                break;
            }
            case 42: {
                this.nodeTest_ = AllElementTest.INSTANCE;
                break;
            }
            case 64: {
                if (toks.nextToken() != -3) {
                    throw new XPathException(xpath, "after @ in node test", toks, "name");
                }
                this.nodeTest_ = new AttrTest(toks.sval);
                break;
            }
            case -3: {
                if (toks.sval.equals("text")) {
                    if (toks.nextToken() != 40 || toks.nextToken() != 41) {
                        throw new XPathException(xpath, "after text", toks, "()");
                    }
                    this.nodeTest_ = TextTest.INSTANCE;
                    break;
                }
                this.nodeTest_ = new ElementTest(toks.sval);
                break;
            }
            default: {
                throw new XPathException(xpath, "at begininning of step", toks, "'.' or '*' or name");
            }
        }
        if (toks.nextToken() == 91) {
            toks.nextToken();
            this.predicate_ = ExprFactory.createExpr(xpath, toks);
            if (toks.ttype != 93) {
                throw new XPathException(xpath, "after predicate expression", toks, "]");
            }
            toks.nextToken();
        } else {
            this.predicate_ = TrueExpr.INSTANCE;
        }
    }

    public String toString() {
        return this.nodeTest_.toString() + this.predicate_.toString();
    }

    public boolean isMultiLevel() {
        return this.multiLevel_;
    }

    public boolean isStringValue() {
        return this.nodeTest_.isStringValue();
    }

    public NodeTest getNodeTest() {
        return this.nodeTest_;
    }

    public BooleanExpr getPredicate() {
        return this.predicate_;
    }
}

