/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.utils;

import com.alibaba.nacos.client.logging.AbstractNacosLogging;
import com.alibaba.nacos.client.logging.log4j2.Log4J2NacosLogging;
import com.alibaba.nacos.client.logging.logback.LogbackNacosLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    public static final Logger NAMING_LOGGER;

    public static Logger logger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz);
    }

    static {
        block7: {
            try {
                AbstractNacosLogging nacosLogging;
                boolean isLogback = false;
                try {
                    Class.forName("ch.qos.logback.classic.Logger");
                    nacosLogging = new LogbackNacosLogging();
                    isLogback = true;
                }
                catch (ClassNotFoundException e) {
                    nacosLogging = new Log4J2NacosLogging();
                }
                try {
                    nacosLogging.loadConfiguration();
                }
                catch (Throwable t) {
                    if (isLogback) {
                        LoggerFactory.getLogger(LogUtils.class).warn("Load Logback Configuration of Nacos fail, message: {}", (Object)t.getMessage());
                        break block7;
                    }
                    LoggerFactory.getLogger(LogUtils.class).warn("Load Log4j Configuration of Nacos fail, message: {}", (Object)t.getMessage());
                }
            }
            catch (Throwable t1) {
                LoggerFactory.getLogger(LogUtils.class).warn("Init Nacos Logging fail, message: {}", (Object)t1.getMessage());
            }
        }
        NAMING_LOGGER = LoggerFactory.getLogger((String)"com.alibaba.nacos.client.naming");
    }
}

