/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.extension;

import com.google.common.base.Preconditions;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.ozhera.log.agent.export.MsgExporter;
import org.apache.ozhera.log.agent.extension.KafkaExporter;
import org.apache.ozhera.log.agent.extension.KafkaOutput;
import org.apache.ozhera.log.agent.output.Output;
import org.apache.ozhera.log.agent.service.OutPutService;
import org.apache.ozhera.log.api.model.meta.LogPattern;
import org.apache.ozhera.log.api.model.meta.MQConfig;
import org.apache.ozhera.log.utils.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(name="KafkaService")
public class KafkaService
implements OutPutService {
    private static final Logger log = LoggerFactory.getLogger(KafkaService.class);
    private ConcurrentHashMap<String, Producer> producerMap;
    @Value(value="$kafka.use.ssl")
    private String kafkaUseSsl;
    @Value(value="$kafka.sll.location")
    private String kafkaSllLocation;

    public void init() {
        this.producerMap = new ConcurrentHashMap(128);
    }

    @Override
    public boolean compare(Output oldOutPut, Output newOutPut) {
        if (!Objects.equals(oldOutPut.getOutputType(), newOutPut.getOutputType())) {
            return false;
        }
        if (oldOutPut instanceof KafkaOutput && newOutPut instanceof KafkaOutput) {
            KafkaOutput oldRmqOutput = (KafkaOutput)oldOutPut;
            KafkaOutput newRmqOutput = (KafkaOutput)newOutPut;
            return oldRmqOutput.equals(newRmqOutput);
        }
        return Objects.equals(oldOutPut, newOutPut);
    }

    @Override
    public void preCheckOutput(Output output) {
        KafkaOutput rmqOutput = (KafkaOutput)output;
        Preconditions.checkArgument((null != rmqOutput.getClusterInfo() ? 1 : 0) != 0, (Object)"rmqOutput.getClusterInfo can not be null");
        Preconditions.checkArgument((null != rmqOutput.getTopic() ? 1 : 0) != 0, (Object)"rmqOutput.getTopic can not be null");
    }

    @Override
    public MsgExporter exporterTrans(Output output) throws Exception {
        KafkaOutput kafkaOutput = (KafkaOutput)output;
        String nameSrvAddr = kafkaOutput.getClusterInfo();
        String key = this.getKey(nameSrvAddr, kafkaOutput.getTopic(), kafkaOutput.getTag());
        Producer mqProducer = this.producerMap.get(key);
        if (null == mqProducer) {
            mqProducer = this.initMqProducer(kafkaOutput);
            this.producerMap.put(key, mqProducer);
        }
        KafkaExporter rmqExporter = new KafkaExporter(mqProducer, output.getTag());
        rmqExporter.setTopic(kafkaOutput.getTopic());
        rmqExporter.setBatchSize(kafkaOutput.getBatchExportSize());
        return rmqExporter;
    }

    private String getKey(String nameSrvAddr, String topic, String tag) {
        return String.format("%s-%s", nameSrvAddr, topic, tag);
    }

    private Producer initMqProducer(KafkaOutput output) {
        Properties properties = new Properties();
        String clusterInfo = output.getClusterInfo();
        String ak = output.getAk();
        String sk = output.getSk();
        if (StringUtils.isNotEmpty((CharSequence)ak) && StringUtils.isNotEmpty((CharSequence)sk) && Objects.equals("true", this.kafkaUseSsl)) {
            properties.putAll((Map<?, ?>)KafkaUtils.getSslKafkaProperties((String)clusterInfo, (String)ak, (String)sk, (String)this.kafkaSllLocation));
        } else if (StringUtils.isNotEmpty((CharSequence)ak) && StringUtils.isNotEmpty((CharSequence)sk)) {
            properties.putAll((Map<?, ?>)KafkaUtils.getVpc9094KafkaProperties((String)clusterInfo, (String)ak, (String)sk));
        } else {
            properties.putAll((Map<?, ?>)KafkaUtils.getDefaultKafkaProperties((String)clusterInfo));
        }
        properties.put("bootstrap.servers", clusterInfo);
        properties.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        properties.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        properties.put("compression.type", "lz4");
        return new KafkaProducer(properties);
    }

    @Override
    public void removeMQ(Output output) {
        KafkaOutput kafkaOutput = (KafkaOutput)output;
        String key = this.getKey(kafkaOutput.getClusterInfo(), kafkaOutput.getTopic(), kafkaOutput.getTag());
        if (null != this.producerMap.get(key)) {
            this.producerMap.get(key).close();
        }
        this.producerMap.remove(key);
    }

    @Override
    public Output configOutPut(LogPattern logPattern) {
        MQConfig mqConfig = logPattern.getMQConfig();
        KafkaOutput output = new KafkaOutput();
        output.setOutputType("kafka");
        output.setClusterInfo(mqConfig.getClusterInfo());
        output.setProducerGroup(mqConfig.getProducerGroup());
        output.setAk(mqConfig.getAk());
        output.setSk(mqConfig.getSk());
        output.setTopic(mqConfig.getTopic());
        output.setPartitionCnt(mqConfig.getPartitionCnt());
        output.setTag(mqConfig.getTag());
        output.setProducerGroup("subGroup_" + (null == logPattern.getPatternCode() ? "" : logPattern.getPatternCode()));
        return output;
    }
}

