/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.nutz.lang.Lang;

public class ReflectTool {
    private static Method DEFINE_CLASS;
    private static final ProtectionDomain PROTECTION_DOMAIN;

    public static ProtectionDomain getProtectionDomain(final Class source) {
        if (source == null) {
            return null;
        }
        return (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return source.getProtectionDomain();
            }
        });
    }

    public static Class defineClass(String className, byte[] b, ClassLoader loader) throws Exception {
        return ReflectTool.defineClass(className, b, loader, PROTECTION_DOMAIN);
    }

    public static Class defineClass(String className, byte[] b, ClassLoader loader, ProtectionDomain protectionDomain) throws Exception {
        Object[] args = new Object[]{className, b, new Integer(0), new Integer(b.length), protectionDomain};
        if (loader == null) {
            loader = ReflectTool.class.getClassLoader();
        }
        Class c = (Class)DEFINE_CLASS.invoke((Object)loader, args);
        Class.forName(className, true, loader);
        return c;
    }

    public static Class<?> getGenericFieldType(Class<?> clazz, Field field) {
        Type fieldType = field.getGenericType();
        return ReflectTool.getRealGenericClass(clazz, fieldType);
    }

    public static Class<?> getParameterRealGenericClass(Class<?> clazz, Type type, int index) {
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            return ReflectTool.getRealGenericClass(clazz, actualTypeArguments[index]);
        }
        return Object.class;
    }

    public static Class<?> getRealGenericClass(Class<?> clazz, Type type) {
        TypeVariable tv;
        Type genericFieldType;
        if (type instanceof TypeVariable && (genericFieldType = ReflectTool.getInheritGenericType(clazz, tv = (TypeVariable)type)) != null) {
            return Lang.getTypeClass(genericFieldType);
        }
        return Lang.getTypeClass(type);
    }

    public static Type getInheritGenericType(Class<?> clazz, Type type) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return ReflectTool.getInheritGenericType(clazz, tv);
        }
        return type;
    }

    public static Type getInheritGenericType(Class<?> clazz, TypeVariable<?> tv) {
        Type type = null;
        Object gd = tv.getGenericDeclaration();
        do {
            if ((type = clazz.getGenericSuperclass()) == null) {
                return null;
            }
            if (type instanceof ParameterizedType) {
                boolean eq;
                ParameterizedType ptype = (ParameterizedType)type;
                Type rawType = ptype.getRawType();
                boolean bl = eq = gd.equals(rawType) || gd instanceof Class && rawType instanceof Class && ((Class)gd).isAssignableFrom((Class)rawType);
                if (eq) {
                    TypeVariable<?>[] tvs = gd.getTypeParameters();
                    Type[] types = ptype.getActualTypeArguments();
                    for (int i = 0; i < tvs.length; ++i) {
                        if (!tv.equals(tvs[i])) continue;
                        return types[i];
                    }
                    return null;
                }
            }
            clazz = Lang.getTypeClass(type);
        } while (type != null);
        return null;
    }

    static {
        PROTECTION_DOMAIN = ReflectTool.getProtectionDomain(ReflectTool.class);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> loader = Class.forName("java.lang.ClassLoader");
                    DEFINE_CLASS = loader.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    DEFINE_CLASS.setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

