/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.handler;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.nutz.json.JsonFormat;
import org.nutz.json.JsonRender;
import org.nutz.json.JsonTypeHandler;
import org.nutz.lang.Mirror;

public class JsonIterableHandler
extends JsonTypeHandler {
    @Override
    public boolean supportFromJson(Mirror<?> mirror, Object obj) {
        return false;
    }

    @Override
    public boolean supportToJson(Mirror<?> mirror, Object obj, JsonFormat jf) {
        return obj instanceof Iterable;
    }

    @Override
    public void toJson(Mirror<?> mirror, Object currentObj, JsonRender r, JsonFormat jf) throws IOException {
        Writer writer = r.getWriter();
        Iterable iterable = (Iterable)currentObj;
        writer.append('[');
        Iterator it = iterable.iterator();
        while (it.hasNext()) {
            r.render(it.next());
            if (!it.hasNext()) break;
            r.appendPairEnd();
            writer.append(' ');
        }
        writer.append(']');
    }

    @Override
    public boolean shallCheckMemo() {
        return true;
    }
}

