/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.io.BufferedInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.nutz.http.Cookie;
import org.nutz.http.Header;
import org.nutz.http.Http;
import org.nutz.http.HttpException;
import org.nutz.http.HttpReqRespInterceptor;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.SenderFactory;
import org.nutz.http.sender.DefaultSenderFactory;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.stream.VoidInputStream;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class Sender
implements Callable<Response> {
    public static int Default_Conn_Timeout = 30000;
    public static int Default_Read_Timeout = 600000;
    private static final Log log = Logs.get();
    protected Request request;
    private int connTimeout;
    private int timeout;
    protected HttpURLConnection conn;
    protected HttpReqRespInterceptor interceptor = new Cookie();
    protected Callback<Response> callback;
    protected boolean followRedirects = true;
    protected SSLSocketFactory sslSocketFactory;
    protected HostnameVerifier hostnameVerifier;
    protected Proxy proxy;
    protected Callback<Integer> progressListener;
    protected static ExecutorService es;
    protected static SenderFactory factory;

    public static Sender create(String url) {
        return Sender.create(Request.get(url));
    }

    public static Sender create(String url, int timeout) {
        return Sender.create(url).setTimeout(timeout);
    }

    public static Sender create(Request request) {
        return factory.create(request);
    }

    public static Sender create(Request request, int timeout) {
        return Sender.create(request).setTimeout(timeout);
    }

    protected Sender(Request request) {
        this.request = request;
    }

    public abstract Response send() throws HttpException;

    protected Response createResponse(NutMap reHeaders) throws IOException {
        Response rep = null;
        if (reHeaders != null) {
            rep = new Response(this.conn, reHeaders);
            String encoding = this.conn.getContentEncoding();
            if (rep.isOK()) {
                InputStream is1 = this.conn.getInputStream();
                InputStream is2 = null;
                is2 = this.detectStreamEncode(encoding, is1);
                BufferedInputStream is = new BufferedInputStream(is2);
                rep.setStream(is);
            } else {
                try {
                    rep.setStream(this.detectStreamEncode(encoding, this.conn.getInputStream()));
                }
                catch (IOException e) {
                    try {
                        rep.setStream(this.detectStreamEncode(encoding, this.conn.getErrorStream()));
                    }
                    catch (Exception e1) {
                        rep.setStream(new VoidInputStream());
                    }
                }
            }
        }
        if (this.interceptor != null) {
            this.interceptor.afterResponse(this.request, this.conn, rep);
        }
        return rep;
    }

    protected InputStream detectStreamEncode(String encoding, InputStream ins) throws IOException {
        if (encoding != null && encoding.contains("gzip")) {
            return new GZIPInputStream(ins);
        }
        if (encoding != null && encoding.contains("deflate")) {
            return new InflaterInputStream(ins, new Inflater(true));
        }
        return ins;
    }

    protected NutMap getResponseHeader() throws IOException {
        if (this.conn.getResponseCode() < 0) {
            throw new IOException("Network error!! resp code=" + this.conn.getResponseCode());
        }
        NutMap re = new NutMap();
        re.putAll(this.conn.getHeaderFields());
        return re;
    }

    protected void setupDoInputOutputFlag() {
        this.conn.setDoInput(true);
        this.conn.setDoOutput(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openConnection() throws IOException {
        int connTime;
        Proxy proxy;
        if (this.interceptor != null) {
            this.interceptor.beforeConnect(this.request);
        }
        if ((proxy = this.proxy) == null && Http.proxySwitcher != null) {
            proxy = Http.proxySwitcher.getProxy(this.request);
        }
        int n = connTime = this.connTimeout > 0 ? this.connTimeout : Default_Conn_Timeout;
        if (proxy != null) {
            try {
                if (Http.autoSwitch) {
                    try (Socket socket = null;){
                        socket = new Socket();
                        socket.connect(proxy.address(), connTime);
                        OutputStream out = socket.getOutputStream();
                        out.write(10);
                        out.flush();
                    }
                }
                log.debug("connect via proxy : " + proxy + " for " + this.request.getUrl());
                this.conn = (HttpURLConnection)this.request.getUrl().openConnection(proxy);
                this.conn.setConnectTimeout(connTime);
                this.conn.setInstanceFollowRedirects(this.followRedirects);
                if (this.timeout > 0) {
                    this.conn.setReadTimeout(this.timeout);
                } else {
                    this.conn.setReadTimeout(Default_Read_Timeout);
                }
                return;
            }
            catch (IOException e) {
                if (!Http.autoSwitch) {
                    throw e;
                }
                log.info("Test proxy FAIl, fallback to direct connection", e);
            }
        }
        URL url = this.request.getUrl();
        String host = url.getHost();
        this.conn = (HttpURLConnection)url.openConnection();
        if (this.conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsc = (HttpsURLConnection)this.conn;
            if (this.sslSocketFactory != null) {
                httpsc.setSSLSocketFactory(this.sslSocketFactory);
            } else if (Http.sslSocketFactory != null) {
                httpsc.setSSLSocketFactory(Http.sslSocketFactory);
            }
            if (this.hostnameVerifier != null) {
                httpsc.setHostnameVerifier(this.hostnameVerifier);
            } else if (Http.hostnameVerifier != null) {
                httpsc.setHostnameVerifier(Http.hostnameVerifier);
            }
        }
        if (!Lang.isIPv4Address(host)) {
            if (url.getPort() > 0 && url.getPort() != 80) {
                host = host + ":" + url.getPort();
            }
            this.conn.addRequestProperty("Host", host);
        }
        this.conn.setConnectTimeout(connTime);
        if (this.request.getMethodString() == null) {
            this.conn.setRequestMethod(this.request.getMethod().name());
        } else {
            this.conn.setRequestMethod(this.request.getMethodString());
        }
        if (this.timeout > 0) {
            this.conn.setReadTimeout(this.timeout);
        } else {
            this.conn.setReadTimeout(Default_Read_Timeout);
        }
        this.conn.setInstanceFollowRedirects(this.followRedirects);
        if (this.interceptor != null) {
            this.interceptor.afterConnect(this.request, this.conn);
        }
    }

    protected void setupRequestHeader() {
        Header header = this.request.getHeader();
        if (null != header) {
            for (String name : header.keys()) {
                List<String> values = header.getValues(name);
                for (String value : values) {
                    if (Strings.isBlank(value)) continue;
                    this.conn.addRequestProperty(name, value);
                }
            }
        }
    }

    public Sender setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Sender setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
        return this;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public Sender setInterceptor(HttpReqRespInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Sender setCallback(Callback<Response> callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public Response call() throws Exception {
        Response resp = this.send();
        if (this.callback != null) {
            this.callback.invoke(resp);
        }
        return resp;
    }

    public Future<Response> send(Callback<Response> callback) throws HttpException {
        if (es == null) {
            throw new IllegalStateException("Sender ExecutorService is null, Call setup first");
        }
        this.callback = callback;
        return es.submit(this);
    }

    public static ExecutorService setup(ExecutorService es) {
        if (Sender.es != null) {
            Sender.shutdown();
        }
        if (es == null) {
            es = Executors.newFixedThreadPool(64);
        }
        Sender.es = es;
        return es;
    }

    public static List<Runnable> shutdown() {
        ExecutorService _es = es;
        es = null;
        if (_es == null) {
            return null;
        }
        return _es.shutdownNow();
    }

    public static ExecutorService getExecutorService() {
        return es;
    }

    public Sender setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    protected OutputStream getOutputStream() throws IOException {
        OutputStream out = this.conn.getOutputStream();
        if (this.progressListener == null) {
            return out;
        }
        return new FilterOutputStream(out){
            int count;

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                this.count += len;
                Sender.this.progressListener.invoke(this.count);
            }
        };
    }

    public int getEstimationSize() throws IOException {
        return 0;
    }

    public Sender setProgressListener(Callback<Integer> progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public Sender setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public Sender setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public static void setFactory(SenderFactory factory) {
        Sender.factory = factory;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    static {
        factory = new DefaultSenderFactory();
    }
}

