/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.stream.exception.StreamException;
import org.apache.ozhera.log.stream.job.compensate.MqMessageDTO;
import org.apache.ozhera.log.stream.job.extension.MqMessageProduct;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMqMessageProduct
implements MqMessageProduct {
    private static final Logger log = LoggerFactory.getLogger(RocketMqMessageProduct.class);
    private Map<String, DefaultMQProducer> producerMap = Maps.newHashMap();

    @Override
    public void product(String ak, String sk, String serviceUrl, String topic, List<String> msgs) {
        String producerGroup = Config.ins().get("rocketmq_group", "hear_log_stream");
        DefaultMQProducer producer = this.getDefaultMQProducer(serviceUrl, producerGroup);
        List messageList = msgs.stream().map(msg -> {
            Message message = new Message();
            message.setTopic(topic);
            message.setBody(msg.getBytes(StandardCharsets.UTF_8));
            return message;
        }).collect(Collectors.toList());
        try {
            producer.send(messageList);
        }
        catch (Exception e) {
            log.error("RocketMqMessageProduct send message error, RocketmqConfig: {},nameSrvAddr:{}", new Object[]{producerGroup, serviceUrl, e});
        }
    }

    private DefaultMQProducer getDefaultMQProducer(String serviceUrl, String producerGroup) {
        DefaultMQProducer producer;
        if (this.producerMap.containsKey(serviceUrl)) {
            producer = this.producerMap.get(serviceUrl);
        } else {
            producer = new DefaultMQProducer(producerGroup, true);
            producer.setNamesrvAddr(serviceUrl);
            try {
                producer.start();
                this.producerMap.put(serviceUrl, producer);
            }
            catch (MQClientException e) {
                log.error("RocketMqMessageProduct.initMqProducer error, RocketmqConfig: {},nameSrvAddr:{}", new Object[]{producerGroup, serviceUrl, e});
                throw new StreamException("initMqProducer exception", e);
            }
        }
        return producer;
    }

    @Override
    public void product(MqMessageDTO msg) {
        String ak = Config.ins().get("rocketmq_ak", "");
        String sk = Config.ins().get("rocketmq_sk", "");
        String serviceUrl = Config.ins().get("rocketmq_service_url", "");
        String topic = Config.ins().get("rocketmq_producer_topic", "");
        this.product(ak, sk, serviceUrl, topic, Lists.newArrayList((Object[])new String[]{Constant.GSON.toJson((Object)msg)}));
        log.info("compensate send message succeed");
    }
}

