/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.mybatis3.javamapper.elements.sqlprovider;

import java.util.List;
import java.util.TreeSet;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.codegen.mybatis3.javamapper.elements.sqlprovider.AbstractJavaProviderMethodGenerator;
import org.mybatis.generator.internal.util.StringUtility;

public class ProviderSelectByExampleWithoutBLOBsMethodGenerator
extends AbstractJavaProviderMethodGenerator {
    public ProviderSelectByExampleWithoutBLOBsMethodGenerator(boolean useLegacyBuilder) {
        super(useLegacyBuilder);
    }

    @Override
    public void addClassElements(TopLevelClass topLevelClass) {
        TreeSet<String> staticImports = new TreeSet<String>();
        TreeSet<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
        if (this.useLegacyBuilder) {
            staticImports.add("org.apache.ibatis.jdbc.SqlBuilder.BEGIN");
            staticImports.add("org.apache.ibatis.jdbc.SqlBuilder.SELECT");
            staticImports.add("org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT");
            staticImports.add("org.apache.ibatis.jdbc.SqlBuilder.FROM");
            staticImports.add("org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY");
            staticImports.add("org.apache.ibatis.jdbc.SqlBuilder.SQL");
        } else {
            importedTypes.add(NEW_BUILDER_IMPORT);
        }
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(this.introspectedTable.getExampleType());
        importedTypes.add(fqjt);
        Method method = new Method(this.getMethodName());
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(FullyQualifiedJavaType.getStringInstance());
        method.addParameter(new Parameter(fqjt, "example"));
        this.context.getCommentGenerator().addGeneralMethodComment(method, this.introspectedTable);
        if (this.useLegacyBuilder) {
            method.addBodyLine("BEGIN();");
        } else {
            method.addBodyLine("SQL sql = new SQL();");
        }
        boolean distinctCheck = true;
        for (IntrospectedColumn introspectedColumn : this.getColumns()) {
            if (distinctCheck) {
                method.addBodyLine("if (example != null && example.isDistinct()) {");
                method.addBodyLine(String.format("%sSELECT_DISTINCT(\"%s\");", this.builderPrefix, StringUtility.escapeStringForJava(MyBatis3FormattingUtilities.getSelectListPhrase(introspectedColumn))));
                method.addBodyLine("} else {");
                method.addBodyLine(String.format("%sSELECT(\"%s\");", this.builderPrefix, StringUtility.escapeStringForJava(MyBatis3FormattingUtilities.getSelectListPhrase(introspectedColumn))));
                method.addBodyLine("}");
            } else {
                method.addBodyLine(String.format("%sSELECT(\"%s\");", this.builderPrefix, StringUtility.escapeStringForJava(MyBatis3FormattingUtilities.getSelectListPhrase(introspectedColumn))));
            }
            distinctCheck = false;
        }
        method.addBodyLine(String.format("%sFROM(\"%s\");", this.builderPrefix, StringUtility.escapeStringForJava(this.introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime())));
        if (this.useLegacyBuilder) {
            method.addBodyLine("applyWhere(example, false);");
        } else {
            method.addBodyLine("applyWhere(sql, example, false);");
        }
        method.addBodyLine("");
        method.addBodyLine("if (example != null && example.getOrderByClause() != null) {");
        method.addBodyLine(String.format("%sORDER_BY(example.getOrderByClause());", this.builderPrefix));
        method.addBodyLine("}");
        method.addBodyLine("");
        if (this.useLegacyBuilder) {
            method.addBodyLine("return SQL();");
        } else {
            method.addBodyLine("return sql.toString();");
        }
        if (this.callPlugins(method, topLevelClass)) {
            topLevelClass.addStaticImports(staticImports);
            topLevelClass.addImportedTypes(importedTypes);
            topLevelClass.addMethod(method);
        }
    }

    public List<IntrospectedColumn> getColumns() {
        return this.introspectedTable.getNonBLOBColumns();
    }

    public String getMethodName() {
        return this.introspectedTable.getSelectByExampleStatementId();
    }

    public boolean callPlugins(Method method, TopLevelClass topLevelClass) {
        return this.context.getPlugins().providerSelectByExampleWithoutBLOBsMethodGenerated(method, topLevelClass, this.introspectedTable);
    }
}

