/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.ibatis2.dao;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractJavaClientGenerator;
import org.mybatis.generator.codegen.AbstractXmlGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.AbstractDAOElementGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.CountByExampleMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.DeleteByExampleMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.DeleteByPrimaryKeyMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.InsertMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.InsertSelectiveMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.SelectByExampleWithBLOBsMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.SelectByExampleWithoutBLOBsMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.SelectByPrimaryKeyMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.UpdateByExampleParmsInnerclassGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.UpdateByExampleSelectiveMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.UpdateByExampleWithBLOBsMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.UpdateByExampleWithoutBLOBsMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.UpdateByPrimaryKeySelectiveMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.UpdateByPrimaryKeyWithBLOBsMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.elements.UpdateByPrimaryKeyWithoutBLOBsMethodGenerator;
import org.mybatis.generator.codegen.ibatis2.dao.templates.AbstractDAOTemplate;
import org.mybatis.generator.internal.rules.Rules;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class DAOGenerator
extends AbstractJavaClientGenerator {
    private AbstractDAOTemplate daoTemplate;
    private boolean generateForJava5;

    public DAOGenerator(AbstractDAOTemplate daoTemplate, boolean generateForJava5) {
        super(true);
        this.daoTemplate = daoTemplate;
        this.generateForJava5 = generateForJava5;
    }

    @Override
    public List<CompilationUnit> getCompilationUnits() {
        FullyQualifiedTable table = this.introspectedTable.getFullyQualifiedTable();
        this.progressCallback.startTask(Messages.getString("Progress.14", table.toString()));
        TopLevelClass topLevelClass = this.getTopLevelClassShell();
        Interface interfaze = this.getInterfaceShell();
        this.addCountByExampleMethod(topLevelClass, interfaze);
        this.addDeleteByExampleMethod(topLevelClass, interfaze);
        this.addDeleteByPrimaryKeyMethod(topLevelClass, interfaze);
        this.addInsertMethod(topLevelClass, interfaze);
        this.addInsertSelectiveMethod(topLevelClass, interfaze);
        this.addSelectByExampleWithBLOBsMethod(topLevelClass, interfaze);
        this.addSelectByExampleWithoutBLOBsMethod(topLevelClass, interfaze);
        this.addSelectByPrimaryKeyMethod(topLevelClass, interfaze);
        this.addUpdateByExampleParmsInnerclass(topLevelClass, interfaze);
        this.addUpdateByExampleSelectiveMethod(topLevelClass, interfaze);
        this.addUpdateByExampleWithBLOBsMethod(topLevelClass, interfaze);
        this.addUpdateByExampleWithoutBLOBsMethod(topLevelClass, interfaze);
        this.addUpdateByPrimaryKeySelectiveMethod(topLevelClass, interfaze);
        this.addUpdateByPrimaryKeyWithBLOBsMethod(topLevelClass, interfaze);
        this.addUpdateByPrimaryKeyWithoutBLOBsMethod(topLevelClass, interfaze);
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        if (this.context.getPlugins().clientGenerated(interfaze, topLevelClass, this.introspectedTable)) {
            answer.add(topLevelClass);
            answer.add(interfaze);
        }
        return answer;
    }

    protected TopLevelClass getTopLevelClassShell() {
        FullyQualifiedJavaType interfaceType = new FullyQualifiedJavaType(this.introspectedTable.getDAOInterfaceType());
        FullyQualifiedJavaType implementationType = new FullyQualifiedJavaType(this.introspectedTable.getDAOImplementationType());
        TopLevelClass answer = new TopLevelClass(implementationType);
        answer.setVisibility(JavaVisibility.PUBLIC);
        answer.setSuperClass(this.daoTemplate.getSuperClass());
        answer.addImportedType(this.daoTemplate.getSuperClass());
        answer.addSuperInterface(interfaceType);
        answer.addImportedType(interfaceType);
        for (FullyQualifiedJavaType fqjt : this.daoTemplate.getImplementationImports()) {
            answer.addImportedType(fqjt);
        }
        CommentGenerator commentGenerator = this.context.getCommentGenerator();
        commentGenerator.addJavaFileComment(answer);
        answer.addMethod(this.daoTemplate.getConstructorClone(commentGenerator, implementationType, this.introspectedTable));
        for (Field field : this.daoTemplate.getFieldClones(commentGenerator, this.introspectedTable)) {
            answer.addField(field);
        }
        for (Method method : this.daoTemplate.getMethodClones(commentGenerator, this.introspectedTable)) {
            answer.addMethod(method);
        }
        return answer;
    }

    protected Interface getInterfaceShell() {
        Interface answer = new Interface(new FullyQualifiedJavaType(this.introspectedTable.getDAOInterfaceType()));
        answer.setVisibility(JavaVisibility.PUBLIC);
        String rootInterface = this.introspectedTable.getTableConfigurationProperty("rootInterface");
        if (!StringUtility.stringHasValue(rootInterface)) {
            rootInterface = this.context.getJavaClientGeneratorConfiguration().getProperty("rootInterface");
        }
        if (StringUtility.stringHasValue(rootInterface)) {
            FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(rootInterface);
            answer.addSuperInterface(fqjt);
            answer.addImportedType(fqjt);
        }
        for (FullyQualifiedJavaType fqjt : this.daoTemplate.getInterfaceImports()) {
            answer.addImportedType(fqjt);
        }
        this.context.getCommentGenerator().addJavaFileComment(answer);
        return answer;
    }

    protected void addCountByExampleMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateCountByExample()) {
            CountByExampleMethodGenerator methodGenerator = new CountByExampleMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addDeleteByExampleMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateDeleteByExample()) {
            DeleteByExampleMethodGenerator methodGenerator = new DeleteByExampleMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addDeleteByPrimaryKeyMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateDeleteByPrimaryKey()) {
            DeleteByPrimaryKeyMethodGenerator methodGenerator = new DeleteByPrimaryKeyMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addInsertMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateInsert()) {
            InsertMethodGenerator methodGenerator = new InsertMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addInsertSelectiveMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateInsertSelective()) {
            InsertSelectiveMethodGenerator methodGenerator = new InsertSelectiveMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addSelectByExampleWithBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateSelectByExampleWithBLOBs()) {
            SelectByExampleWithBLOBsMethodGenerator methodGenerator = new SelectByExampleWithBLOBsMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addSelectByExampleWithoutBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateSelectByExampleWithoutBLOBs()) {
            SelectByExampleWithoutBLOBsMethodGenerator methodGenerator = new SelectByExampleWithoutBLOBsMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addSelectByPrimaryKeyMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateSelectByPrimaryKey()) {
            SelectByPrimaryKeyMethodGenerator methodGenerator = new SelectByPrimaryKeyMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByExampleParmsInnerclass(TopLevelClass topLevelClass, Interface interfaze) {
        Rules rules = this.introspectedTable.getRules();
        if (rules.generateUpdateByExampleSelective() || rules.generateUpdateByExampleWithBLOBs() || rules.generateUpdateByExampleWithoutBLOBs()) {
            UpdateByExampleParmsInnerclassGenerator methodGenerator = new UpdateByExampleParmsInnerclassGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByExampleSelectiveMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByExampleSelective()) {
            UpdateByExampleSelectiveMethodGenerator methodGenerator = new UpdateByExampleSelectiveMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByExampleWithBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByExampleWithBLOBs()) {
            UpdateByExampleWithBLOBsMethodGenerator methodGenerator = new UpdateByExampleWithBLOBsMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByExampleWithoutBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByExampleWithoutBLOBs()) {
            UpdateByExampleWithoutBLOBsMethodGenerator methodGenerator = new UpdateByExampleWithoutBLOBsMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByPrimaryKeySelectiveMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByPrimaryKeySelective()) {
            UpdateByPrimaryKeySelectiveMethodGenerator methodGenerator = new UpdateByPrimaryKeySelectiveMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByPrimaryKeyWithBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByPrimaryKeyWithBLOBs()) {
            UpdateByPrimaryKeyWithBLOBsMethodGenerator methodGenerator = new UpdateByPrimaryKeyWithBLOBsMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByPrimaryKeyWithoutBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByPrimaryKeyWithoutBLOBs()) {
            UpdateByPrimaryKeyWithoutBLOBsMethodGenerator methodGenerator = new UpdateByPrimaryKeyWithoutBLOBsMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void initializeAndExecuteGenerator(AbstractDAOElementGenerator methodGenerator, TopLevelClass topLevelClass, Interface interfaze) {
        methodGenerator.setDAOTemplate(this.daoTemplate);
        methodGenerator.setContext(this.context);
        methodGenerator.setIntrospectedTable(this.introspectedTable);
        methodGenerator.setProgressCallback(this.progressCallback);
        methodGenerator.setWarnings(this.warnings);
        methodGenerator.addImplementationElements(topLevelClass);
        methodGenerator.addInterfaceElements(interfaze);
    }

    @Override
    public AbstractXmlGenerator getMatchedXMLGenerator() {
        return null;
    }
}

