/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeSelector;
import io.fabric8.kubernetes.api.model.NodeSelectorFluent;
import io.fabric8.kubernetes.api.model.NodeSelectorFluentImpl;
import java.util.Objects;

public class NodeSelectorBuilder
extends NodeSelectorFluentImpl<NodeSelectorBuilder>
implements VisitableBuilder<NodeSelector, NodeSelectorBuilder> {
    NodeSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public NodeSelectorBuilder() {
        this(false);
    }

    public NodeSelectorBuilder(Boolean validationEnabled) {
        this(new NodeSelector(), validationEnabled);
    }

    public NodeSelectorBuilder(NodeSelectorFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NodeSelectorBuilder(NodeSelectorFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeSelector(), validationEnabled);
    }

    public NodeSelectorBuilder(NodeSelectorFluent<?> fluent, NodeSelector instance) {
        this(fluent, instance, false);
    }

    public NodeSelectorBuilder(NodeSelectorFluent<?> fluent, NodeSelector instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNodeSelectorTerms(instance.getNodeSelectorTerms());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public NodeSelectorBuilder(NodeSelector instance) {
        this(instance, (Boolean)false);
    }

    public NodeSelectorBuilder(NodeSelector instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNodeSelectorTerms(instance.getNodeSelectorTerms());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NodeSelector build() {
        NodeSelector buildable = new NodeSelector(this.fluent.getNodeSelectorTerms());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSelectorBuilder that = (NodeSelectorBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

