/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.alertManagerClient;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.aliyun.arms20190808.models.CreateOrUpdateAlertRuleResponse;
import com.aliyun.arms20190808.models.CreateOrUpdateNotificationPolicyResponse;
import com.aliyun.arms20190808.models.CreateOrUpdateWebhookContactResponse;
import com.aliyun.arms20190808.models.DeleteAlertRuleResponse;
import com.aliyun.arms20190808.models.DescribeWebhookContactsResponse;
import com.aliyun.arms20190808.models.GetAlertRulesResponse;
import com.aliyun.arms20190808.models.GetAlertRulesResponseBody;
import com.aliyun.arms20190808.models.ListNotificationPoliciesResponse;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import org.apache.ozhera.prometheus.agent.client.Client;
import org.apache.ozhera.prometheus.agent.enums.RuleAlertStatusEnum;
import org.apache.ozhera.prometheus.agent.operators.ali.AliPrometheusOperator;
import org.apache.ozhera.prometheus.agent.param.alertManager.Rule;
import org.apache.ozhera.prometheus.agent.param.prometheus.ali.AliNotifyObjects;
import org.apache.ozhera.prometheus.agent.param.prometheus.ali.AliNotifyRule;
import org.apache.ozhera.prometheus.agent.service.prometheus.RuleAlertService;
import org.apache.ozhera.prometheus.agent.util.CommitPoolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AlertManagerAliClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(AlertManagerAliClient.class);
    @NacosValue(value="${job.alertManager.enabled}", autoRefreshed=true)
    private String enabled;
    private boolean firstInitSign = false;
    @Autowired
    RuleAlertService ruleAlertService;
    @Autowired
    AliPrometheusOperator aliOperator;
    private ConcurrentHashMap<String, CopyOnWriteArrayList<Rule>> localRuleList = new ConcurrentHashMap();
    private ConcurrentHashMap<String, CopyOnWriteArrayList<Rule>> needDeleteRuleList = new ConcurrentHashMap();
    private Float webHookId = Float.valueOf(0.0f);
    private Long notifyStrategyId = 0L;
    private static final Gson gson = new Gson();

    @PostConstruct
    public void init() {
        log.info("AlertManagerAliClient begin init!");
        if (this.enabled.equals("true")) {
            Long alertNotifyStrategyId;
            Float alertWebHookId;
            this.webHookId = alertWebHookId = this.getAlertWebHook();
            this.notifyStrategyId = alertNotifyStrategyId = this.getNotifyStrategyId();
            if (alertWebHookId == null || alertNotifyStrategyId == null) {
                log.error("AlertManagerAliClient request webhook or request notify strategy fail !!!");
                System.exit(-3);
            }
            this.GetLocalConfigs();
            this.CompareAndReload();
        } else {
            log.info("AlertManagerAliClient not init");
        }
    }

    @Override
    public void GetLocalConfigs() {
        CommitPoolUtil.ALERTMANAGER_LOCAL_CONFIG_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            log.info("AlertManagerAliClient start GetLocalConfigs");
            try {
                List allRuleAlertList = this.ruleAlertService.GetAllCloudRuleAlertList(RuleAlertStatusEnum.ALL.getDesc());
                this.localRuleList.clear();
                this.needDeleteRuleList.clear();
                log.info("AlertManagerAliClient GetLocalConfigs allRuleAlertList: {}", (Object)allRuleAlertList);
                allRuleAlertList.forEach(item -> {
                    String tmpGroup = item.getAlert_group();
                    Rule rule = new Rule();
                    rule.setAlert(item.getName());
                    rule.setAnnotations(this.transAnnotation2Map(item.getAnnotation()));
                    rule.setLabels(this.transLabel2Map(item.getLabels()));
                    rule.setExpr(item.getExpr());
                    rule.setFor(item.getAlertFor());
                    if (item.getStatus().equals(RuleAlertStatusEnum.DELETE.getDesc()) || item.getEnabled() == 0 || item.getDeletedTime() != null) {
                        if (this.needDeleteRuleList.containsKey(tmpGroup)) {
                            this.needDeleteRuleList.get(tmpGroup).add(rule);
                        } else {
                            CopyOnWriteArrayList rules = new CopyOnWriteArrayList();
                            this.needDeleteRuleList.put(tmpGroup, rules);
                            this.needDeleteRuleList.get(tmpGroup).add(rule);
                        }
                    } else if (this.localRuleList.containsKey(tmpGroup)) {
                        this.localRuleList.get(tmpGroup).add(rule);
                    } else {
                        CopyOnWriteArrayList rules = new CopyOnWriteArrayList();
                        this.localRuleList.put(tmpGroup, rules);
                        this.localRuleList.get(tmpGroup).add(rule);
                    }
                });
                log.info("AlertManagerAliClient GetLocalConfigs done!");
                this.firstInitSign = true;
            }
            catch (Exception e) {
                log.error("AlertManagerAliClient GetLocalConfigs error:{}", (Object)e.getMessage());
            }
            finally {
                log.info("AlertManagerAliClient GetLocalConfigs batch time:{}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void CompareAndReload() {
        CommitPoolUtil.ALERTMANAGER_COMPARE_RELOAD_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            try {
                if (this.localRuleList.isEmpty()) {
                    log.info("localRuleList is empty and no need reload");
                    return;
                }
                if (!this.firstInitSign) {
                    log.info("AlertManagerAliClient CompareAndReload waiting..");
                    return;
                }
                log.info("AlertManagerAliClient start CompareAndReload");
                this.createOrUpdateAliAlertRule();
            }
            catch (Exception e) {
                log.error("AlertManagerAliClient CompareAndReload error: {}", (Throwable)e);
            }
            finally {
                log.info("AlertManagerAliClient end CompareAndReload cost: {}ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    public Float getAlertWebHook() {
        try {
            DescribeWebhookContactsResponse describeWebhookContactsResponse = this.aliOperator.DescribeWebhookContacts();
            if (describeWebhookContactsResponse == null || !Objects.equals(describeWebhookContactsResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                log.error("AlertManagerAliClient.getAlertWebHook.DescribeWebhookContacts not successful!");
                return null;
            }
            if (describeWebhookContactsResponse.getBody().getPageBean().total == 0L) {
                log.info("ozhera webhook not founded and begin init");
                CreateOrUpdateWebhookContactResponse createOrUpdateWebhookContactResponse = this.aliOperator.CreateOrUpdateWebhookContact();
                if (createOrUpdateWebhookContactResponse == null || !Objects.equals(createOrUpdateWebhookContactResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                    log.error("AlertManagerAliClient.getAlertWebHook.CreateOrUpdateWebhookContact not successful!");
                    return null;
                }
                return createOrUpdateWebhookContactResponse.getBody().getWebhookContact().getWebhookId();
            }
            AtomicReference remoteWebHookId = new AtomicReference();
            describeWebhookContactsResponse.getBody().getPageBean().getWebhookContacts().forEach(webhook -> {
                if (webhook.webhookName.equals("OZHera")) {
                    log.info("ozhera webhook already exist");
                    remoteWebHookId.set(webhook.getWebhookId());
                }
            });
            if (remoteWebHookId.get() != null) {
                return (Float)remoteWebHookId.get();
            }
            CreateOrUpdateWebhookContactResponse createOrUpdateWebhookContactResponse = this.aliOperator.CreateOrUpdateWebhookContact();
            if (createOrUpdateWebhookContactResponse == null || !Objects.equals(createOrUpdateWebhookContactResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                log.error("AlertManagerAliClient.getAlertWebHook.CreateOrUpdateWebhookContact not successful!");
                return null;
            }
            return createOrUpdateWebhookContactResponse.getBody().getWebhookContact().getWebhookId();
        }
        catch (Exception e) {
            log.error("AlertManagerAliClient getAlertWebHook error: {}", (Throwable)e);
            return null;
        }
    }

    public Long getNotifyStrategyId() {
        try {
            ListNotificationPoliciesResponse listNotificationPoliciesResponse = this.aliOperator.ListNotificationPolicies();
            if (listNotificationPoliciesResponse == null || !Objects.equals(listNotificationPoliciesResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                log.error("AlertManagerAliClient.getNotifyStrategyId.ListNotificationPolicies not successful!");
                return null;
            }
            if (listNotificationPoliciesResponse.getBody().getPageBean().total == 0L) {
                log.info("ozhera notify strategy not founded and begin init");
                String notifyRule = gson.toJson((Object)this.createAliNotifyRule());
                CreateOrUpdateNotificationPolicyResponse createOrUpdateNotificationPolicyResponse = this.aliOperator.CreateOrUpdateNotificationPolicy(notifyRule);
                if (createOrUpdateNotificationPolicyResponse == null || !Objects.equals(createOrUpdateNotificationPolicyResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                    log.error("AlertManagerAliClient.getNotifyStrategyId.createOrUpdateNotificationPolicyResponse not successful!");
                    return null;
                }
                return createOrUpdateNotificationPolicyResponse.getBody().getNotificationPolicy().getId();
            }
            AtomicReference remoteStrategyId = new AtomicReference();
            List notificationPolicies = listNotificationPoliciesResponse.getBody().getPageBean().getNotificationPolicies();
            notificationPolicies.forEach(strategy -> {
                if (strategy.name.equals("OZHera_default_notify_strategy")) {
                    log.info("ozhera notify strategy already exist");
                    remoteStrategyId.set(strategy.getId());
                }
            });
            if (remoteStrategyId.get() != null) {
                return (Long)remoteStrategyId.get();
            }
            log.info("ozhera notify strategy not founded and begin init");
            String notifyRule = gson.toJson((Object)this.createAliNotifyRule());
            CreateOrUpdateNotificationPolicyResponse createOrUpdateNotificationPolicyResponse = this.aliOperator.CreateOrUpdateNotificationPolicy(notifyRule);
            if (createOrUpdateNotificationPolicyResponse == null || !Objects.equals(createOrUpdateNotificationPolicyResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                log.error("AlertManagerAliClient.getNotifyStrategyId.createOrUpdateNotificationPolicyResponse not successful!");
                return null;
            }
            return createOrUpdateNotificationPolicyResponse.getBody().getNotificationPolicy().getId();
        }
        catch (Exception e) {
            log.error("AlertManagerAliClient getNotifyStrategyId error: {}", (Throwable)e);
            return null;
        }
    }

    private AliNotifyRule createAliNotifyRule() {
        AliNotifyRule aliNotifyRule = new AliNotifyRule();
        aliNotifyRule.setNotifyStartTime("00:00");
        aliNotifyRule.setNotifyEndTime("23:59");
        ArrayList<String> aliNotifyChannel = new ArrayList<String>();
        aliNotifyChannel.add("webhook");
        aliNotifyRule.setNotifyChannels(aliNotifyChannel);
        List<AliNotifyObjects> aliNotifyObjectsList = this.getAliNotifyObjects();
        aliNotifyRule.setNotifyObjects(aliNotifyObjectsList);
        return aliNotifyRule;
    }

    private List<AliNotifyObjects> getAliNotifyObjects() {
        AliNotifyObjects aliNotifyObjects = new AliNotifyObjects();
        aliNotifyObjects.setNotifyObjectType("CONTACT");
        aliNotifyObjects.setNotifyObjectId(Long.valueOf((long)this.webHookId.floatValue()));
        aliNotifyObjects.setNotifyObjectName("OZHera");
        ArrayList<String> aliObjectNotifyChannel = new ArrayList<String>();
        aliObjectNotifyChannel.add("webhook");
        aliNotifyObjects.setNotifyChannels(aliObjectNotifyChannel);
        ArrayList<AliNotifyObjects> aliNotifyObjectsList = new ArrayList<AliNotifyObjects>();
        aliNotifyObjectsList.add(aliNotifyObjects);
        return aliNotifyObjectsList;
    }

    private Map<String, String> transLabel2Map(String labels) {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        try {
            Arrays.stream(labels.split(",")).forEach(item -> {
                String[] split = item.split("=", 2);
                if (split.length != 2) {
                    return;
                }
                labelMap.put(split[0], split[1]);
            });
            return labelMap;
        }
        catch (Exception e) {
            log.error("AlertManagerClient transLabel2Map error: {}", (Throwable)e);
            return labelMap;
        }
    }

    private Map<String, String> transAnnotation2Map(String annotations) {
        Map annotationMap = (Map)gson.fromJson(annotations, Map.class);
        return annotationMap;
    }

    private void createOrUpdateAliAlertRule() {
        log.info("AlertManagerAliClient.createOrUpdateAliAlertRule begin,operator is :{}", (Object)this.aliOperator.printTriplicities());
        try {
            this.needDeleteRuleList.get("example").forEach(deleteAlertRule -> {
                Float remoteAlertIdRuleByAlertName = this.getRemoteAlertIdRuleByAlertName(deleteAlertRule.getAlert());
                if (remoteAlertIdRuleByAlertName.floatValue() == -1.0f) {
                    return;
                }
                DeleteAlertRuleResponse deleteAlertRuleResponse = this.aliOperator.DeleteAlertRule((long)remoteAlertIdRuleByAlertName.floatValue());
                if (deleteAlertRuleResponse == null || !Objects.equals(deleteAlertRuleResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                    log.info("PrometheusAliClient.createOrUpdateAliAlertRule.getRemoteAlertIdRuleByAlertName Not successful,alertName:{}", (Object)deleteAlertRule.getAlert());
                } else {
                    this.ruleAlertService.UpdateRuleAlertDeleteToDone(deleteAlertRule.getAlert());
                }
            });
            GetAlertRulesResponse getAlertRulesResponse = this.aliOperator.GetAlertRules(null);
            if (getAlertRulesResponse == null || !Objects.equals(getAlertRulesResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                log.error("AlertManagerAliClient.createOrUpdateAliAlertRule.GetAlertRules Not successful!");
                return;
            }
            List remoteAlertRules = getAlertRulesResponse.getBody().getPageBean().getAlertRules();
            if (this.localRuleList.isEmpty()) {
                log.info("AlertManagerAliClient.createOrUpdateAliAlertRule.localRuleList is empty");
                return;
            }
            this.localRuleList.get("example").forEach(alert -> this.innerCreateOrUpdateAlertRules(false, remoteAlertRules, alert.getAlert()));
        }
        catch (Exception ex) {
            log.info("AlertManagerAliClient.createOrUpdateAliAlertRule error :{}", (Object)ex.getMessage());
        }
    }

    private void innerCreateOrUpdateAlertRules(boolean isFirst, List<GetAlertRulesResponseBody.GetAlertRulesResponseBodyPageBeanAlertRules> remoteAlertRules, String alertName) {
        AtomicBoolean isFindInRemote = new AtomicBoolean(false);
        remoteAlertRules.forEach(remoteAlert -> {
            if (remoteAlert.getAlertName().equals(alertName)) {
                Rule localAlertByAlertName = this.getLocalAlertByAlertName(alertName);
                CreateOrUpdateAlertRuleResponse createOrUpdateAlertRuleResponse = this.aliOperator.CreateOrUpdateAlertRule("RUNNING", String.valueOf(this.notifyStrategyId), localAlertByAlertName, remoteAlert.getAlertId());
                if (createOrUpdateAlertRuleResponse == null || !Objects.equals(createOrUpdateAlertRuleResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                    log.error("PrometheusAliClient.innerCreateOrUpdateAlertRules.CreateOrUpdateAlertRule Not successful,alertName:{}", (Object)remoteAlert.getAlertName());
                }
                isFindInRemote.set(true);
            }
        });
        if (!isFindInRemote.get()) {
            Rule localAlertByAlertName = this.getLocalAlertByAlertName(alertName);
            CreateOrUpdateAlertRuleResponse createOrUpdateAlertRuleResponse = this.aliOperator.CreateOrUpdateAlertRule("RUNNING", String.valueOf(this.notifyStrategyId), localAlertByAlertName, null);
            if (createOrUpdateAlertRuleResponse == null || !Objects.equals(createOrUpdateAlertRuleResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                log.error("PrometheusAliClient.innerCreateOrUpdateAlertRules.CreateOrUpdateAlertRule Not successful,alertName:{}", (Object)alertName);
            }
        }
    }

    private Rule getLocalAlertByAlertName(String alertName) {
        AtomicReference targetAlert = new AtomicReference();
        this.localRuleList.get("example").forEach(alert -> {
            if (alert.getAlert().equals(alertName)) {
                targetAlert.set(alert);
            }
        });
        return (Rule)targetAlert.get();
    }

    private Float getRemoteAlertIdRuleByAlertName(String alertName) {
        GetAlertRulesResponse getAlertRulesResponse = this.aliOperator.GetAlertRules(alertName);
        if (getAlertRulesResponse == null || getAlertRulesResponse.getBody().getPageBean() == null || getAlertRulesResponse.getBody().getPageBean().size == 0L || getAlertRulesResponse.getBody().getPageBean().getAlertRules().isEmpty() || !Objects.equals(getAlertRulesResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
            log.error("PrometheusAliClient.innerCreateOrUpdateAlertRules.getRemoteAlertIdRuleByAlertName Not successful,alertName:{}", (Object)alertName);
            return Float.valueOf(-1.0f);
        }
        return ((GetAlertRulesResponseBody.GetAlertRulesResponseBodyPageBeanAlertRules)getAlertRulesResponse.getBody().getPageBean().getAlertRules().get(0)).getAlertId();
    }
}

