/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.controller;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.List;
import org.apache.ozhera.prometheus.agent.enums.ErrorCode;
import org.apache.ozhera.prometheus.agent.result.Result;
import org.apache.ozhera.prometheus.agent.service.dto.SilenceAlertManagerReqBuilder;
import org.apache.ozhera.prometheus.agent.service.dto.dingding.SilenceCallBack;
import org.apache.ozhera.prometheus.agent.service.prometheus.RuleSilenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1"})
public class PrometheusSilenceController {
    private static final Logger log = LoggerFactory.getLogger(PrometheusSilenceController.class);
    @Autowired
    RuleSilenceService ruleSilenceService;
    private final Gson gson = new Gson();

    @RequestMapping(value={"/silence"}, method={RequestMethod.POST})
    public Result createRuleSilence(@RequestBody Object param) {
        log.info("createRuleSilence param:{}", param);
        try {
            String json = this.gson.toJson(param);
            SilenceAlertManagerReqBuilder silenceAlertManagerReqBuilder = this.parseSilenceData(json);
            if (silenceAlertManagerReqBuilder == null) {
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            Result result = this.ruleSilenceService.createRuleSilence(silenceAlertManagerReqBuilder);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/silence/{id}"}, method={RequestMethod.PUT})
    public Result updateRuleSilence() {
        return null;
    }

    @RequestMapping(value={"/silence/{id}"}, method={RequestMethod.DELETE})
    public Result deleteRuleSilence() {
        return null;
    }

    @RequestMapping(value={"/silence/cancel/{id}"}, method={RequestMethod.PUT})
    public Result cancelRuleSilence() {
        return null;
    }

    @RequestMapping(value={"/silence/{id}"}, method={RequestMethod.GET})
    public Result searchRuleSilence() {
        return null;
    }

    @RequestMapping(value={"/silence/list"}, method={RequestMethod.POST})
    public Result searchRuleSilenceList() {
        return null;
    }

    private SilenceAlertManagerReqBuilder parseSilenceData(String json) {
        log.info("createRuleSilence json:{}", (Object)json);
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(json, JsonObject.class);
        SilenceCallBack silenceCallBack = (SilenceCallBack)this.gson.fromJson((JsonElement)jsonObject, SilenceCallBack.class);
        JsonObject contentJsonObject = JsonParser.parseString((String)silenceCallBack.getContent()).getAsJsonObject();
        JsonPrimitive valueObject = contentJsonObject.getAsJsonObject("cardPrivateData").getAsJsonObject("params").getAsJsonPrimitive("value");
        String cardCallBackStr = valueObject.getAsString();
        List<String> cardCallBackList = Arrays.asList(cardCallBackStr.split("\\|\\|"));
        if (cardCallBackList.size() != 5) {
            log.error("cardCallBackList size not valid");
            return null;
        }
        SilenceAlertManagerReqBuilder builder = new SilenceAlertManagerReqBuilder();
        builder.setOutTrackId(silenceCallBack.getOutTrackId());
        builder.setUserId(silenceCallBack.getUserId());
        builder.setApplication(cardCallBackList.get(0));
        builder.setAlertName(cardCallBackList.get(1));
        builder.setContent(cardCallBackList.get(2));
        builder.setCallbackTitle(cardCallBackList.get(3));
        builder.setExpectedSilenceTime(cardCallBackList.get(4));
        return builder;
    }
}

