/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.common.param;

import com.xiaomi.mone.tpc.common.param.ArgCheck;
import com.xiaomi.mone.tpc.common.vo.PageDataVo;
import java.io.Serializable;

public abstract class BaseParam
implements ArgCheck,
Serializable {
    private Long userId;
    private String account;
    private Integer userType;
    private Integer page;
    private Integer pageSize;
    private Boolean pager;
    private String token;

    public <T> PageDataVo<T> buildPageDataVo() {
        return this.buildPageDataVo(999);
    }

    public <T> PageDataVo<T> buildPageDataVo(int maxPageSize) {
        PageDataVo pageDataVo = new PageDataVo();
        if (this.pager == null) {
            this.pager = false;
        }
        if (this.page == null) {
            this.page = 1;
        }
        if (this.pageSize == null) {
            this.pageSize = 100;
        }
        if (this.page <= 0 || !this.pager.booleanValue()) {
            pageDataVo.setPage(1);
        } else {
            pageDataVo.setPage(this.page);
        }
        if (this.pageSize <= 0) {
            pageDataVo.setPageSize(100);
        } else if (this.pageSize <= maxPageSize) {
            pageDataVo.setPageSize(this.pageSize);
        } else {
            pageDataVo.setPageSize(maxPageSize);
        }
        pageDataVo.setPager(this.pager);
        return pageDataVo;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getAccount() {
        return this.account;
    }

    public Integer getUserType() {
        return this.userType;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Boolean getPager() {
        return this.pager;
    }

    public String getToken() {
        return this.token;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPager(Boolean pager) {
        this.pager = pager;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseParam)) {
            return false;
        }
        BaseParam other = (BaseParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$userType = this.getUserType();
        Integer other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !((Object)this$userType).equals(other$userType)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Boolean this$pager = this.getPager();
        Boolean other$pager = other.getPager();
        if (this$pager == null ? other$pager != null : !((Object)this$pager).equals(other$pager)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : ((Object)$userType).hashCode());
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Boolean $pager = this.getPager();
        result = result * 59 + ($pager == null ? 43 : ((Object)$pager).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "BaseParam(userId=" + this.getUserId() + ", account=" + this.getAccount() + ", userType=" + this.getUserType() + ", page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ", pager=" + this.getPager() + ", token=" + this.getToken() + ")";
    }
}

